/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.bungee;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.Varint21LengthFieldPrepender;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.util.BungeeReflectionUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class BungeeInjector
extends CommonPlatformInjector {
    private static final String BUNGEE_INIT = "floodgate-bungee-init";
    private final FloodgateLogger logger;
    private boolean injected;

    public boolean inject() {
        try {
            Field framePrepender = ReflectionUtils.getField(PipelineUtils.class, (String)"framePrepender");
            BungeeCustomPrepender customPrepender = new BungeeCustomPrepender(this, (Varint21LengthFieldPrepender)ReflectionUtils.getCastedValue(null, (Field)framePrepender));
            BungeeReflectionUtils.setFieldValue(null, framePrepender, (Object)customPrepender);
            this.injected = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean canRemoveInjection() {
        return false;
    }

    public boolean removeInjection() {
        this.logger.error("Floodgate cannot remove itself from Bungee without a reboot", new Object[0]);
        return false;
    }

    void injectClient(Channel channel, boolean clientToProxy) {
        if (!channel.isOpen()) {
            return;
        }
        if (channel.pipeline().get(MinecraftEncoder.class) == null) {
            this.logger.debug("Minecraft encoder not found while injecting! {}", new Object[]{String.join((CharSequence)", ", channel.pipeline().names())});
            return;
        }
        this.injectAddonsCall(channel, !clientToProxy);
        this.addInjectedClient(channel);
    }

    public BungeeInjector(FloodgateLogger logger) {
        this.logger = logger;
    }

    public boolean isInjected() {
        return this.injected;
    }

    private static final class BungeeProxyToServerInjectInitializer
    extends ChannelOutboundHandlerAdapter {
        private final BungeeInjector injector;

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.injector.injectClient(ctx.channel(), false);
            ctx.pipeline().remove((ChannelHandler)this);
            super.write(ctx, msg, promise);
        }

        public BungeeProxyToServerInjectInitializer(BungeeInjector injector) {
            this.injector = injector;
        }
    }

    private static final class BungeeClientToProxyInjectInitializer
    extends ChannelInboundHandlerAdapter {
        private final BungeeInjector injector;

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.injector.injectClient(ctx.channel(), true);
            ctx.pipeline().remove((ChannelHandler)this);
            super.channelRead(ctx, msg);
        }

        public BungeeClientToProxyInjectInitializer(BungeeInjector injector) {
            this.injector = injector;
        }
    }

    private static final class BungeeCustomPrepender
    extends Varint21LengthFieldPrepender {
        private final BungeeInjector injector;
        private final Varint21LengthFieldPrepender original;

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.original.handlerAdded(ctx);
            if (ctx.channel().parent() != null) {
                ctx.pipeline().addBefore("frame-decoder", BungeeInjector.BUNGEE_INIT, (ChannelHandler)new BungeeClientToProxyInjectInitializer(this.injector));
            } else {
                ctx.pipeline().addLast(BungeeInjector.BUNGEE_INIT, (ChannelHandler)new BungeeProxyToServerInjectInitializer(this.injector));
            }
        }

        public BungeeCustomPrepender(BungeeInjector injector, Varint21LengthFieldPrepender original) {
            this.injector = injector;
            this.original = original;
        }
    }
}

