/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.BungeeUserAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.Utils;

public final class BungeeCommandUtil
implements CommandUtil {
    public static final @NonNull Map<UUID, UserAudience> AUDIENCE_CACHE = new HashMap<UUID, UserAudience>();
    private static UserAudience console;
    private final ProxyServer server;
    private final FloodgateApi api;
    private final FloodgateLogger logger;
    private final LanguageManager manager;

    public @NonNull UserAudience getAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSender)) {
            throw new IllegalArgumentException("Can only work with CommandSource!");
        }
        CommandSender source = (CommandSender)sourceObj;
        if (!(source instanceof ProxiedPlayer)) {
            if (console != null) {
                return console;
            }
            console = new BungeeUserAudience.BungeeConsoleAudience(source, this);
            return console;
        }
        ProxiedPlayer player = (ProxiedPlayer)source;
        UUID uuid = player.getUniqueId();
        String username = player.getName();
        String locale = Utils.getLocale((Locale)player.getLocale());
        return AUDIENCE_CACHE.computeIfAbsent(uuid, $ -> new BungeeUserAudience.BungeePlayerAudience(uuid, username, locale, source, true, this));
    }

    public @Nullable UserAudience getAudienceByUsername(@NonNull String username) {
        ProxiedPlayer player = this.server.getPlayer(username);
        return player != null ? this.getAudience(player) : null;
    }

    public @NonNull UserAudience getOfflineAudienceByUsername(@NonNull String username) {
        return new BungeeUserAudience.BungeePlayerAudience(null, username, null, null, false, this);
    }

    public @Nullable UserAudience getAudienceByUuid(@NonNull UUID uuid) {
        ProxiedPlayer player = this.server.getPlayer(uuid);
        return player != null ? this.getAudience(player) : null;
    }

    public @NonNull UserAudience getOfflineAudienceByUuid(@NonNull UUID uuid) {
        return new BungeeUserAudience.BungeePlayerAudience(uuid, null, null, null, false, this);
    }

    public @NonNull Collection<String> getOnlineUsernames(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UserAudienceArgument.PlayerType limitTo) {
        Collection players = this.server.getPlayers();
        ArrayList<String> usernames = new ArrayList<String>();
        switch (limitTo) {
            case ALL_PLAYERS: {
                for (ProxiedPlayer player : players) {
                    usernames.add(player.getName());
                }
                break;
            }
            case ONLY_JAVA: {
                for (ProxiedPlayer player : players) {
                    if (this.api.isFloodgatePlayer(player.getUniqueId())) continue;
                    usernames.add(player.getName());
                }
                break;
            }
            case ONLY_BEDROCK: {
                for (ProxiedPlayer player : players) {
                    if (!this.api.isFloodgatePlayer(player.getUniqueId())) continue;
                    usernames.add(player.getName());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PlayerType");
            }
        }
        return usernames;
    }

    public boolean hasPermission(Object player, String permission) {
        return this.cast(player).hasPermission(permission);
    }

    public Collection<Object> getOnlinePlayersWithPermission(String permission) {
        ArrayList<Object> players = new ArrayList<Object>();
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            if (!this.hasPermission(player, permission)) continue;
            players.add(player);
        }
        return players;
    }

    public void sendMessage(Object target, String locale, TranslatableMessage message, Object ... args) {
        ((CommandSender)target).sendMessage(this.translateAndTransform(locale, message, args));
    }

    public void sendMessage(Object target, String message) {
        ((CommandSender)target).sendMessage(message);
    }

    public void kickPlayer(Object player, String locale, TranslatableMessage message, Object ... args) {
        this.cast(player).disconnect(this.translateAndTransform(locale, message, args));
    }

    public BaseComponent[] translateAndTransform(String locale, TranslatableMessage message, Object ... args) {
        return TextComponent.fromLegacyText((String)message.translateMessage(this.manager, locale, args));
    }

    protected ProxiedPlayer cast(Object player) {
        try {
            return (ProxiedPlayer)player;
        }
        catch (ClassCastException exception) {
            this.logger.error("Failed to cast {} to ProxiedPlayer", new Object[]{player.getClass().getName()});
            throw exception;
        }
    }

    public BungeeCommandUtil(ProxyServer server, FloodgateApi api, FloodgateLogger logger, LanguageManager manager) {
        this.server = server;
        this.api = api;
        this.logger = logger;
        this.manager = manager;
    }
}

