/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.geysermc.floodgate.util.MessageFormatter;
import sun.misc.Unsafe;

public class BungeeReflectionUtils {
    private static final Unsafe UNSAFE;

    public static void setFieldValue(Object object, Field field, Object result) {
        try {
            long offset;
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            long l = offset = isStatic ? UNSAFE.staticFieldOffset(field) : UNSAFE.objectFieldOffset(field);
            if (isStatic) {
                UNSAFE.putObject(UNSAFE.staticFieldBase(field), offset, result);
            } else {
                UNSAFE.putObject(object, offset, result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(MessageFormatter.format((String)"Java version: {}\nVendor: {} ({})", (Object[])new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vendor.url"), e}));
        }
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(MessageFormatter.format((String)"Cannot initialize required reflection setup :/\nJava version: {}\nVendor: {} ({})", (Object[])new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.vendor.url")}), exception);
        }
    }
}

