/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.addonmanager;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.geysermc.floodgate.inject.CommonPlatformInjector;

public final class AddonManagerHandler
extends MessageToByteEncoder<ByteBuf> {
    private final CommonPlatformInjector injector;
    private final Channel channel;
    private boolean loggedIn;
    private boolean removed;

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (!this.removed) {
            this.removed = true;
            this.injector.removeAddonsCall(this.channel);
        }
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        if (this.loggedIn) {
            out.writeBytes(msg);
            return;
        }
        int index = msg.readerIndex();
        if (this.readVarInt(msg) == 2) {
            this.loggedIn = true;
            this.injector.loginSuccessCall(this.channel);
        }
        msg.readerIndex(index);
        out.writeBytes(msg);
    }

    private int readVarInt(ByteBuf buffer) {
        byte current;
        int out = 0;
        int count = 0;
        do {
            current = buffer.readByte();
            out |= (current & 0x7F) << count++ * 7;
            if (count <= 5) continue;
            throw new RuntimeException("VarInt is bigger then allowed");
        } while ((current & 0x80) != 0);
        return out;
    }

    public AddonManagerHandler(CommonPlatformInjector injector, Channel channel) {
        this.injector = injector;
        this.channel = channel;
    }
}

