/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.geysermc.floodgate.api.logger.FloodgateLogger;

public final class ChannelInDebugHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final String message;
    private final FloodgateLogger logger;

    public ChannelInDebugHandler(String implementationType, boolean toServer, FloodgateLogger logger) {
        this.message = (toServer ? "Server ->" : "Player ->") + ' ' + implementationType;
        this.logger = logger;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        int index = msg.readerIndex();
        this.logger.info("{}:\n{}", new Object[]{this.message, ByteBufUtil.prettyHexDump((ByteBuf)msg)});
        msg.readerIndex(index);
        ctx.fireChannelRead((Object)msg.retain());
    }
}

