/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.geysermc.floodgate.api.logger.FloodgateLogger;

public final class ChannelOutDebugHandler
extends MessageToByteEncoder<ByteBuf> {
    private final String direction;
    private final FloodgateLogger logger;

    public ChannelOutDebugHandler(String implementationType, boolean toServer, FloodgateLogger logger) {
        this.direction = implementationType + (toServer ? " -> Server" : " -> Player");
        this.logger = logger;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        int index = msg.readerIndex();
        this.logger.info("{}:\n{}", new Object[]{this.direction, ByteBufUtil.prettyHexDump((ByteBuf)msg)});
        msg.readerIndex(index);
        out.writeBytes(msg);
    }
}

