/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.api;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.geysermc.cumulus.Form;
import org.geysermc.cumulus.util.FormBuilder;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfigHolder;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.pluginmessage.channel.FormChannel;
import org.geysermc.floodgate.util.HttpUtils;
import org.geysermc.floodgate.util.Utils;

public class SimpleFloodgateApi
implements FloodgateApi {
    private final Map<UUID, FloodgatePlayer> players = new HashMap<UUID, FloodgatePlayer>();
    private final PluginMessageManager pluginMessageManager;
    private final FloodgateConfigHolder configHolder;

    public String getPlayerPrefix() {
        return this.configHolder.get().getUsernamePrefix();
    }

    public Collection<FloodgatePlayer> getPlayers() {
        return ImmutableSet.copyOf(this.players.values());
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public boolean isFloodgatePlayer(UUID uuid) {
        return this.getPlayer(uuid) != null;
    }

    public FloodgatePlayer getPlayer(UUID uuid) {
        FloodgatePlayer selfPlayer = this.players.get(uuid);
        if (selfPlayer != null || this.isFloodgateId(uuid)) {
            return selfPlayer;
        }
        for (FloodgatePlayer player : this.players.values()) {
            if (!player.getCorrectUniqueId().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public UUID createJavaPlayerId(long xuid) {
        return Utils.getJavaUuid(xuid);
    }

    public boolean isFloodgateId(UUID uuid) {
        return uuid.getMostSignificantBits() == 0L;
    }

    public boolean sendForm(UUID uuid, Form form) {
        return this.pluginMessageManager.getChannel(FormChannel.class).sendForm(uuid, form);
    }

    public boolean sendForm(UUID uuid, FormBuilder<?, ?> formBuilder) {
        return this.sendForm(uuid, formBuilder.build());
    }

    public CompletableFuture<Long> getXuidFor(String gamertag) {
        if (gamertag == null || gamertag.isEmpty() || gamertag.length() > 16) {
            return Utils.failedFuture(new IllegalStateException("Received an invalid gamertag"));
        }
        return HttpUtils.asyncGet("https://api.geysermc.org/v1/xbox/xuid/" + gamertag).thenApply(result -> {
            JsonObject response = result.getResponse();
            boolean success = response.get("success").getAsBoolean();
            if (!success) {
                throw new IllegalStateException(response.get("message").getAsString());
            }
            JsonObject data = response.getAsJsonObject("data");
            if (data.size() == 0) {
                return null;
            }
            return data.get("xuid").getAsLong();
        });
    }

    public CompletableFuture<String> getGamertagFor(long xuid) {
        return HttpUtils.asyncGet("https://api.geysermc.org/v1/xbox/gamertag/" + xuid).thenApply(result -> {
            JsonObject response = result.getResponse();
            boolean success = response.get("success").getAsBoolean();
            if (!success) {
                throw new IllegalStateException(response.get("message").getAsString());
            }
            JsonObject data = response.getAsJsonObject("data");
            if (data.size() == 0) {
                return null;
            }
            return data.get("gamertag").getAsString();
        });
    }

    public FloodgatePlayer addPlayer(UUID uuid, FloodgatePlayer player) {
        return this.players.put(uuid, player);
    }

    @Nullable
    public FloodgatePlayer removePlayer(UUID onlineId, boolean removeLogin) {
        FloodgatePlayer selfPlayer = this.players.get(onlineId);
        if (selfPlayer != null) {
            if (selfPlayer.getLinkedPlayer() != null) {
                return null;
            }
            if (!this.canRemove(selfPlayer, removeLogin)) {
                return null;
            }
            this.players.remove(onlineId);
            return selfPlayer;
        }
        for (FloodgatePlayer player : this.players.values()) {
            if (!this.canRemove(player, removeLogin) || !player.getCorrectUniqueId().equals(onlineId)) continue;
            this.players.remove(player.getJavaUniqueId());
            return player;
        }
        return null;
    }

    protected boolean canRemove(FloodgatePlayer player, boolean removeLogin) {
        FloodgatePlayerImpl impl = (FloodgatePlayerImpl)player.as(FloodgatePlayerImpl.class);
        return impl.isLogin() && removeLogin || !impl.isLogin() && !removeLogin;
    }

    public FloodgatePlayer removePlayer(UUID onlineId) {
        return this.removePlayer(onlineId, false);
    }

    public boolean removePlayer(FloodgatePlayer player) {
        return this.players.remove(player.getJavaUniqueId(), player);
    }

    public SimpleFloodgateApi(PluginMessageManager pluginMessageManager, FloodgateConfigHolder configHolder) {
        this.pluginMessageManager = pluginMessageManager;
        this.configHolder = configHolder;
    }
}

