/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.standard.StringArgument;
import cloud.commandframework.context.CommandContext;
import com.google.inject.Inject;
import net.kyori.adventure.text.Component;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.link.LinkRequestResult;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.command.CommonCommandMessage;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.link.GlobalPlayerLinking;
import org.geysermc.floodgate.platform.command.CommandMessage;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.player.UserAudienceArgument;

public final class LinkAccountCommand
implements FloodgateCommand {
    @Inject
    private FloodgateApi api;
    @Inject
    private FloodgateLogger logger;

    @Override
    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        return commandManager.commandBuilder("linkaccount", ArgumentDescription.of((String)"Link your Java account with your Bedrock account"), new String[0]).senderType(UserAudience.PlayerAudience.class).permission("floodgate.command.linkaccount").argument((CommandArgument)UserAudienceArgument.of("player", true)).argument(StringArgument.optional((String)"code")).handler(this::execute).build();
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
        UserAudience sender = (UserAudience)context.getSender();
        PlayerLink link = this.api.getPlayerLink();
        if (link instanceof GlobalPlayerLinking) {
            if (((GlobalPlayerLinking)link).getDatabaseImpl() != null) {
                sender.sendMessage(CommonCommandMessage.LOCAL_LINKING_NOTICE, "https://link.geysermc.org/");
            } else {
                sender.sendMessage(CommonCommandMessage.GLOBAL_LINKING_NOTICE, "https://link.geysermc.org/");
                return;
            }
        }
        if (!link.isEnabledAndAllowed()) {
            sender.sendMessage(CommonCommandMessage.LINKING_DISABLED, new Object[0]);
            return;
        }
        if (this.api.isFloodgatePlayer(sender.uuid())) {
            if (!context.contains("code")) {
                sender.sendMessage(Message.BEDROCK_USAGE, new Object[0]);
                return;
            }
            UserAudience targetUser = (UserAudience)context.get("player");
            String targetName = targetUser.username();
            String code = (String)context.get("code");
            link.verifyLinkRequest(sender.uuid(), targetName, sender.username(), code).whenComplete((result, throwable) -> {
                if (throwable != null || result == LinkRequestResult.UNKNOWN_ERROR) {
                    sender.sendMessage(Message.LINK_REQUEST_ERROR, new Object[0]);
                    return;
                }
                switch (result) {
                    case ALREADY_LINKED: {
                        sender.sendMessage(Message.ALREADY_LINKED, new Object[0]);
                        break;
                    }
                    case NO_LINK_REQUESTED: {
                        sender.sendMessage(Message.NO_LINK_REQUESTED, new Object[0]);
                        break;
                    }
                    case INVALID_CODE: {
                        sender.sendMessage(Message.INVALID_CODE, new Object[0]);
                        break;
                    }
                    case REQUEST_EXPIRED: {
                        sender.sendMessage(Message.LINK_REQUEST_EXPIRED, new Object[0]);
                        break;
                    }
                    case LINK_COMPLETED: {
                        sender.disconnect(Message.LINK_REQUEST_COMPLETED, targetName);
                        break;
                    }
                    default: {
                        sender.disconnect((Component)Component.text((String)"Invalid account linking result"));
                    }
                }
            });
            return;
        }
        if (context.contains("code")) {
            sender.sendMessage(Message.JAVA_USAGE, new Object[0]);
            return;
        }
        UserAudience targetUser = (UserAudience)context.get("player");
        String targetName = targetUser.username();
        link.createLinkRequest(sender.uuid(), sender.username(), targetName).whenComplete((result, throwable) -> {
            if (throwable != null || result == LinkRequestResult.UNKNOWN_ERROR) {
                sender.sendMessage(Message.LINK_REQUEST_ERROR, new Object[0]);
                return;
            }
            if (!(result instanceof String)) {
                this.logger.error("Expected string code, got {}", new Object[]{result});
                sender.sendMessage(Message.LINK_REQUEST_ERROR, new Object[0]);
                return;
            }
            sender.sendMessage(Message.LINK_REQUEST_CREATED, targetName, sender.username(), result);
        });
    }

    @Override
    public boolean shouldRegister(FloodgateConfig config) {
        FloodgateConfig.PlayerLinkConfig linkConfig = config.getPlayerLink();
        return linkConfig.isEnabled() && (linkConfig.isEnableOwnLinking() || linkConfig.isEnableGlobalLinking());
    }

    public static enum Message implements CommandMessage
    {
        ALREADY_LINKED("floodgate.command.link_account.already_linked"),
        JAVA_USAGE("floodgate.command.link_account.java_usage"),
        LINK_REQUEST_CREATED("floodgate.command.link_account.link_request_created"),
        BEDROCK_USAGE("floodgate.command.link_account.bedrock_usage"),
        LINK_REQUEST_EXPIRED("floodgate.command.link_account.link_request_expired"),
        LINK_REQUEST_COMPLETED("floodgate.command.link_account.link_request_completed"),
        LINK_REQUEST_ERROR("floodgate.command.link_request.error " + CommonCommandMessage.CHECK_CONSOLE),
        INVALID_CODE("floodgate.command.link_account.invalid_code"),
        NO_LINK_REQUESTED("floodgate.command.link_account.no_link_requested");

        private final String rawMessage;
        private final String[] translateParts;

        private Message(String rawMessage) {
            this.rawMessage = rawMessage;
            this.translateParts = rawMessage.split(" ");
        }

        @Override
        public String getRawMessage() {
            return this.rawMessage;
        }

        @Override
        public String[] getTranslateParts() {
            return this.translateParts;
        }
    }
}

