/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.config.loader;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class ConfigInitializer {
    private static final Yaml YAML;

    public static <T extends FloodgateConfig> T initializeFrom(InputStream dataStream, Class<T> configClass) {
        return (T)((FloodgateConfig)YAML.loadAs(dataStream, configClass));
    }

    static {
        CustomClassLoaderConstructor constructor = new CustomClassLoaderConstructor(ConfigInitializer.class.getClassLoader());
        constructor.setPropertyUtils(new PropertyUtils(){

            protected Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess bAccess) {
                LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
                this.getPropertiesFromClass(type, FloodgateConfig.class, properties);
                return properties;
            }

            private void getPropertiesFromClass(Class<?> type, Class<?> stopAfter, Map<String, Property> propertyMap) {
                Class<?> current = type;
                while (!Object.class.equals(current)) {
                    for (Field field : current.getDeclaredFields()) {
                        int modifiers = field.getModifiers();
                        if (!Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers)) {
                            String correctName = this.getCorrectName(field.getName());
                            propertyMap.putIfAbsent(correctName, (Property)new FieldProperty(field));
                        }
                        if (!field.getClass().getSuperclass().equals(current)) continue;
                        this.getPropertiesFromClass(field.getClass(), field.getClass(), propertyMap);
                    }
                    if (current.equals(stopAfter)) {
                        return;
                    }
                    current = type.getSuperclass();
                }
            }

            private String getCorrectName(String name) {
                StringBuilder propertyBuilder = new StringBuilder();
                for (int i = 0; i < name.length(); ++i) {
                    char current = name.charAt(i);
                    if (Character.isUpperCase(current)) {
                        propertyBuilder.append('-').append(Character.toLowerCase(current));
                        continue;
                    }
                    propertyBuilder.append(current);
                }
                return propertyBuilder.toString();
            }
        });
        constructor.getPropertyUtils().setSkipMissingProperties(true);
        YAML = new Yaml((BaseConstructor)constructor);
    }
}

