/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.config.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.config.loader.ConfigInitializer;
import org.geysermc.floodgate.config.loader.DefaultConfigHandler;
import org.geysermc.floodgate.config.updater.ConfigUpdater;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.crypto.KeyProducer;

public final class ConfigLoader {
    private final Path dataFolder;
    private final Class<? extends FloodgateConfig> configClass;
    private final DefaultConfigHandler configCreator;
    private final ConfigUpdater updater;
    private final KeyProducer keyProducer;
    private final FloodgateCipher cipher;
    private final FloodgateLogger logger;

    public <T extends FloodgateConfig> T load() {
        FloodgateConfig configInstance;
        boolean newConfig;
        Path configPath = this.dataFolder.resolve("config.yml");
        String defaultConfigName = "config.yml";
        boolean proxy = ProxyFloodgateConfig.class.isAssignableFrom(this.configClass);
        if (proxy) {
            defaultConfigName = "proxy-" + defaultConfigName;
        }
        boolean bl = newConfig = !Files.exists(configPath, new LinkOption[0]);
        if (newConfig) {
            try {
                this.configCreator.createDefaultConfig(defaultConfigName, configPath);
            }
            catch (Exception exception) {
                this.logger.error("Error while creating config", (Throwable)exception, new Object[0]);
            }
        }
        try {
            if (!newConfig) {
                this.updater.update(this, defaultConfigName);
            }
            FloodgateConfig config = ConfigInitializer.initializeFrom(Files.newInputStream(configPath, new OpenOption[0]), this.configClass);
            try {
                configInstance = config;
            }
            catch (ClassCastException exception) {
                this.logger.error("Failed to cast config file to required class.", (Throwable)exception, new Object[0]);
                throw new RuntimeException(exception);
            }
        }
        catch (Exception exception) {
            this.logger.error("Error while loading config", (Throwable)exception, new Object[0]);
            throw new RuntimeException("Failed to load the config! Try to delete the config file", exception);
        }
        Path keyPath = this.dataFolder.resolve(configInstance.getKeyFileName());
        if (!Files.exists(keyPath, new LinkOption[0])) {
            this.generateKey(keyPath);
        }
        try {
            Key key = this.keyProducer.produceFrom(keyPath);
            this.cipher.init(key);
            configInstance.setKey(key);
        }
        catch (IOException exception) {
            this.logger.error("Error while reading the key", (Throwable)exception, new Object[0]);
            throw new RuntimeException("Failed to read the key!", exception);
        }
        return (T)configInstance;
    }

    public void generateKey(Path keyPath) {
        try {
            Key key = this.keyProducer.produce();
            this.cipher.init(key);
            String test = "abcdefghijklmnopqrstuvwxyz0123456789";
            byte[] encrypted = this.cipher.encryptFromString(test);
            String decrypted = this.cipher.decryptToString(encrypted);
            if (!test.equals(decrypted)) {
                this.logger.error("Whoops, we tested the generated Floodgate keys but the decrypted test message doesn't match the original.\nOriginal message: " + test + ".Decrypted message: " + decrypted + ".\nThe encrypted message itself: " + new String(encrypted), new Object[0]);
                throw new RuntimeException("Tested the generated public and private key but, the decrypted message doesn't match the original!");
            }
            Files.write(keyPath, key.getEncoded(), new OpenOption[0]);
        }
        catch (Exception exception) {
            this.logger.error("Error while creating key", (Throwable)exception, new Object[0]);
        }
    }

    public ConfigLoader(Path dataFolder, Class<? extends FloodgateConfig> configClass, DefaultConfigHandler configCreator, ConfigUpdater updater, KeyProducer keyProducer, FloodgateCipher cipher, FloodgateLogger logger) {
        this.dataFolder = dataFolder;
        this.configClass = configClass;
        this.configCreator = configCreator;
        this.updater = updater;
        this.keyProducer = keyProducer;
        this.cipher = cipher;
        this.logger = logger;
    }
}

