/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.config.updater;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.loader.DefaultConfigHandler;

public final class ConfigFileUpdater {
    @Inject
    private FloodgateLogger logger;
    @Inject
    private DefaultConfigHandler defaultConfigHandler;

    public void update(Path configLocation, Map<String, Object> currentVersion, Map<String, String> renames, String defaultConfigLocation) throws IOException {
        ArrayList<String> notFound = new ArrayList<String>();
        List<String> newConfig = this.defaultConfigHandler.loadDefaultConfig(defaultConfigLocation);
        String spaces = "";
        Map map = null;
        for (int i = 0; i < newConfig.size(); ++i) {
            String v;
            String tempName;
            int splitIndex;
            String line = newConfig.get(i);
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            StringBuilder currentSpaces = new StringBuilder();
            while (line.charAt(currentSpaces.length()) == ' ') {
                currentSpaces.append(32);
            }
            if (!spaces.isEmpty() && currentSpaces.length() < spaces.length()) {
                spaces = "";
                map = null;
            }
            if (line.charAt(currentSpaces.length()) == '#' || (splitIndex = line.indexOf(58)) == -1) continue;
            if (line.length() == splitIndex + 1) {
                if (currentSpaces.length() > 0) {
                    throw new IllegalStateException("Config too complex! I can't understand subcategories of a subcategory");
                }
                spaces = "  ";
                map = (Map)currentVersion.get(line.substring(0, splitIndex));
                continue;
            }
            String name = line.substring(spaces.length(), splitIndex);
            if (name.equals("config-version")) continue;
            String oldName = name;
            do {
                tempName = oldName;
            } while (!(oldName = renames.getOrDefault(oldName, oldName)).equals(tempName));
            Object value = map != null ? map.get(oldName) : currentVersion.get(spaces + oldName);
            if (value == null) {
                notFound.add(name);
                continue;
            }
            if (!(!(value instanceof String) || (v = (String)value).startsWith("\"") && v.endsWith("\""))) {
                value = "\"" + value + "\"";
            }
            this.logger.debug(name + " has been changed to " + value, new Object[0]);
            newConfig.set(i, spaces + name + ": " + value);
        }
        Files.deleteIfExists(configLocation.getParent().resolve("config-old.yml"));
        Files.copy(configLocation, configLocation.getParent().resolve("config-old.yml"), new CopyOption[0]);
        Files.write(configLocation, newConfig, new OpenOption[0]);
        this.logger.info("Successfully updated the config file! Your old config has been moved to config-old.yml", new Object[0]);
        if (!notFound.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder("Please note that the following keys we not found in the old config and are now using the default Floodgate config value. Missing/new keys: ");
            boolean first = true;
            for (String value : notFound) {
                String renamed;
                if (!first) {
                    messageBuilder.append(", ");
                }
                if ((renamed = renames.get(value)) != null) {
                    messageBuilder.append(renamed).append(" to ");
                }
                messageBuilder.append(value);
                first = false;
            }
            this.logger.info(messageBuilder.toString(), new Object[0]);
        }
    }
}

