/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import java.time.Instant;
import java.util.UUID;
import org.geysermc.floodgate.api.link.LinkRequest;

public final class LinkRequestImpl
implements LinkRequest {
    private final String javaUsername;
    private final UUID javaUniqueId;
    private final String linkCode;
    private final String bedrockUsername;
    private final long requestTime;

    public LinkRequestImpl(String javaUsername, UUID javaUniqueId, String linkCode, String bedrockUsername) {
        this.javaUniqueId = javaUniqueId;
        this.javaUsername = javaUsername;
        this.linkCode = linkCode;
        this.bedrockUsername = bedrockUsername;
        this.requestTime = Instant.now().getEpochSecond();
    }

    public LinkRequestImpl(String javaUsername, UUID javaUniqueId, String linkCode, String bedrockUsername, long requestTime) {
        this.javaUniqueId = javaUniqueId;
        this.javaUsername = javaUsername;
        this.linkCode = linkCode;
        this.bedrockUsername = bedrockUsername;
        this.requestTime = requestTime;
    }

    public boolean isExpired(long linkTimeout) {
        long timePassed = Instant.now().getEpochSecond() - this.requestTime;
        return timePassed > linkTimeout;
    }

    public String getJavaUsername() {
        return this.javaUsername;
    }

    public UUID getJavaUniqueId() {
        return this.javaUniqueId;
    }

    public String getLinkCode() {
        return this.linkCode;
    }

    public String getBedrockUsername() {
        return this.bedrockUsername;
    }

    public long getRequestTime() {
        return this.requestTime;
    }
}

