/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.link.DisabledPlayerLink;
import org.geysermc.floodgate.link.GlobalPlayerLinking;
import org.geysermc.floodgate.util.InjectorHolder;
import org.geysermc.floodgate.util.Utils;

@Singleton
public final class PlayerLinkLoader {
    @Inject
    private Injector injector;
    @Inject
    private FloodgateConfig config;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="dataDirectory")
    private Path dataDirectory;

    public PlayerLink load() {
        String databaseName;
        List files;
        if (this.config == null) {
            throw new IllegalStateException("Config cannot be null!");
        }
        FloodgateConfig.PlayerLinkConfig lConfig = this.config.getPlayerLink();
        if (!lConfig.isEnabled()) {
            return new DisabledPlayerLink();
        }
        try {
            files = Files.list(this.dataDirectory).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith("jar")).collect(Collectors.toList());
        }
        catch (IOException exception) {
            this.logger.error("Failed to list possible database implementations", (Throwable)exception, new Object[0]);
            return null;
        }
        if (lConfig.isEnableGlobalLinking() && (files.isEmpty() || !lConfig.isEnableOwnLinking())) {
            return (PlayerLink)this.injector.getInstance(GlobalPlayerLinking.class);
        }
        if (files.isEmpty()) {
            this.logger.error("Failed to find a database implementation", new Object[0]);
            return null;
        }
        Path implementationPath = (Path)files.get(0);
        if (files.size() > 1) {
            boolean found = false;
            databaseName = lConfig.getType();
            String expectedName = "floodgate-" + databaseName + "-database.jar";
            for (Path path2 : files) {
                if (!expectedName.equalsIgnoreCase(path2.getFileName().toString())) continue;
                implementationPath = path2;
                found = true;
            }
            if (!found) {
                this.logger.error("Failed to find an implementation for type: {}", new Object[]{lConfig.getType()});
                return null;
            }
        } else {
            String name = implementationPath.getFileName().toString();
            if (!Utils.isValidDatabaseName(name)) {
                this.logger.error("Found database {} but the name doesn't match {}", new Object[]{name, "^floodgate-[a-zA-Z0-9_]{0,16}-database.jar$"});
                return null;
            }
            int firstSplit = name.indexOf(45) + 1;
            databaseName = name.substring(firstSplit, name.indexOf(45, firstSplit));
        }
        boolean init = true;
        try {
            String mainClassName;
            JsonObject linkConfig;
            URL pluginUrl = implementationPath.toUri().toURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{pluginUrl}, PlayerLinkLoader.class.getClassLoader());
            try (InputStream linkConfigStream = classLoader.getResourceAsStream("init.json");){
                Objects.requireNonNull(linkConfigStream, "Implementation should have an init file");
                linkConfig = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(linkConfigStream), JsonObject.class);
                mainClassName = linkConfig.get("mainClass").getAsString();
            }
            Class<?> mainClass = classLoader.loadClass(mainClassName);
            init = false;
            InjectorHolder injectorHolder = new InjectorHolder();
            Injector linkInjector = this.injector.createChildInjector(new Module[]{binder -> {
                binder.bind(String.class).annotatedWith((Annotation)Names.named((String)"databaseName")).toInstance((Object)databaseName);
                binder.bind(ClassLoader.class).annotatedWith((Annotation)Names.named((String)"databaseClassLoader")).toInstance((Object)classLoader);
                binder.bind(JsonObject.class).annotatedWith((Annotation)Names.named((String)"databaseInitData")).toInstance((Object)linkConfig);
                binder.bind(InjectorHolder.class).toInstance((Object)injectorHolder);
            }});
            injectorHolder.set(linkInjector);
            PlayerLink instance = (PlayerLink)linkInjector.getInstance(mainClass);
            if (lConfig.isEnableGlobalLinking()) {
                GlobalPlayerLinking linking = (GlobalPlayerLinking)linkInjector.getInstance(GlobalPlayerLinking.class);
                linking.setDatabaseImpl(instance);
                linking.load();
                return linking;
            }
            instance.load();
            return instance;
        }
        catch (ClassCastException exception) {
            this.logger.error("The database implementation ({}) doesn't extend the PlayerLink class!", new Object[]{implementationPath.getFileName().toString(), exception});
            return null;
        }
        catch (Exception exception) {
            if (init) {
                this.logger.error("Error while initialising database jar", (Throwable)exception, new Object[0]);
            } else {
                this.logger.error("Error while loading database jar", (Throwable)exception, new Object[0]);
            }
            return null;
        }
    }
}

