/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.netty.util.AttributeKey;
import java.nio.file.Path;
import org.geysermc.floodgate.addon.data.HandshakeHandlersImpl;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.handshake.HandshakeHandlers;
import org.geysermc.floodgate.api.inject.PlatformInjector;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.FloodgateConfigHolder;
import org.geysermc.floodgate.config.loader.ConfigLoader;
import org.geysermc.floodgate.config.loader.DefaultConfigHandler;
import org.geysermc.floodgate.config.updater.ConfigFileUpdater;
import org.geysermc.floodgate.config.updater.ConfigUpdater;
import org.geysermc.floodgate.crypto.AesCipher;
import org.geysermc.floodgate.crypto.AesKeyProducer;
import org.geysermc.floodgate.crypto.Base64Topping;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.crypto.KeyProducer;
import org.geysermc.floodgate.crypto.Topping;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.packet.PacketHandlersImpl;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.pluginmessage.PluginMessageManager;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinUploadManager;
import org.geysermc.floodgate.util.LanguageManager;

public class CommonModule
extends AbstractModule {
    private final Path dataDirectory;

    protected void configure() {
        this.bind(FloodgateApi.class).to(SimpleFloodgateApi.class);
        this.bind(PlatformInjector.class).to(CommonPlatformInjector.class);
        this.bind(HandshakeHandlers.class).to(HandshakeHandlersImpl.class);
        this.bind(PacketHandlers.class).to(PacketHandlersImpl.class);
        this.bind(PacketHandlersImpl.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public KeyProducer keyProducer() {
        return new AesKeyProducer();
    }

    @Provides
    @Singleton
    public FloodgateCipher cipher() {
        return new AesCipher((Topping)new Base64Topping());
    }

    @Provides
    @Singleton
    @Named(value="dataDirectory")
    public Path dataDirectory() {
        return this.dataDirectory;
    }

    @Provides
    @Singleton
    public FloodgateConfigHolder configHolder() {
        return new FloodgateConfigHolder();
    }

    @Provides
    @Singleton
    public ConfigLoader configLoader(@Named(value="configClass") Class<? extends FloodgateConfig> configClass, DefaultConfigHandler defaultConfigHandler, ConfigUpdater configUpdater, KeyProducer producer, FloodgateCipher cipher, FloodgateLogger logger) {
        return new ConfigLoader(this.dataDirectory, configClass, defaultConfigHandler, configUpdater, producer, cipher, logger);
    }

    @Provides
    @Singleton
    public DefaultConfigHandler defaultConfigCreator() {
        return new DefaultConfigHandler();
    }

    @Provides
    @Singleton
    public ConfigUpdater configUpdater(ConfigFileUpdater configFileUpdater, FloodgateLogger logger) {
        return new ConfigUpdater(this.dataDirectory, configFileUpdater, logger);
    }

    @Provides
    @Singleton
    public LanguageManager languageLoader(FloodgateConfigHolder configHolder, FloodgateLogger logger) {
        return new LanguageManager(configHolder, logger);
    }

    @Provides
    @Singleton
    public HandshakeHandlersImpl handshakeHandlers() {
        return new HandshakeHandlersImpl();
    }

    @Provides
    @Singleton
    public FloodgateHandshakeHandler handshakeHandler(HandshakeHandlersImpl handshakeHandlers, SimpleFloodgateApi api, FloodgateCipher cipher, FloodgateConfigHolder configHolder, SkinUploadManager skinUploadManager, @Named(value="playerAttribute") AttributeKey<FloodgatePlayer> playerAttribute, FloodgateLogger logger) {
        return new FloodgateHandshakeHandler(handshakeHandlers, api, cipher, configHolder, skinUploadManager, playerAttribute, logger);
    }

    @Provides
    @Singleton
    public PluginMessageManager pluginMessageManager() {
        return new PluginMessageManager();
    }

    @Provides
    @Singleton
    public SkinUploadManager skinUploadManager(FloodgateApi api, SkinApplier skinApplier, FloodgateLogger logger) {
        return new SkinUploadManager(api, skinApplier, logger);
    }

    @Provides
    @Singleton
    @Named(value="kickMessageAttribute")
    public AttributeKey<String> kickMessageAttribute() {
        return AttributeKey.valueOf((String)"floodgate-kick-message");
    }

    @Provides
    @Singleton
    @Named(value="playerAttribute")
    public AttributeKey<FloodgatePlayer> playerAttribute() {
        return AttributeKey.valueOf((String)"floodgate-player");
    }

    public CommonModule(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
    }
}

