/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.player;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.geysermc.floodgate.addon.data.HandshakeDataImpl;
import org.geysermc.floodgate.addon.data.HandshakeHandlersImpl;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.config.FloodgateConfigHolder;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.skin.SkinUploadManager;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.InvalidFormatException;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.Utils;

public final class FloodgateHandshakeHandler {
    private final Cache<String, Long> handleCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final HandshakeHandlersImpl handshakeHandlers;
    private final SimpleFloodgateApi api;
    private final FloodgateCipher cipher;
    private final FloodgateConfigHolder configHolder;
    private final SkinUploadManager skinUploadManager;
    private final AttributeKey<FloodgatePlayer> playerAttribute;
    private final FloodgateLogger logger;

    public HandshakeResult handle(Channel channel, @NonNull String originalHostname) {
        if (originalHostname == null) {
            throw new NullPointerException("originalHostname is marked non-null but is null");
        }
        String[] split = originalHostname.split("\u0000");
        String data = null;
        StringBuilder hostnameBuilder = new StringBuilder();
        for (String value : split) {
            if (data == null && FloodgateCipher.hasHeader((String)value)) {
                data = value;
                continue;
            }
            hostnameBuilder.append(value).append('\u0000');
        }
        String hostname = hostnameBuilder.toString();
        if (data == null) {
            return this.callHandlerAndReturnResult(ResultType.NOT_FLOODGATE_DATA, channel, null, hostname);
        }
        try {
            byte[] floodgateData = data.getBytes(Charsets.UTF_8);
            String decrypted = this.cipher.decryptToString(floodgateData);
            BedrockData bedrockData = BedrockData.fromString((String)decrypted);
            if (bedrockData.getDataLength() != 13) {
                return this.callHandlerAndReturnResult(ResultType.INVALID_DATA_LENGTH, channel, bedrockData, hostname);
            }
            long timeDifference = System.currentTimeMillis() - bedrockData.getTimestamp();
            if (timeDifference > 6000L || timeDifference < 0L) {
                return this.callHandlerAndReturnResult(ResultType.TIMESTAMP_DENIED, channel, bedrockData, hostname);
            }
            Long cachedTimestamp = (Long)this.handleCache.getIfPresent((Object)bedrockData.getXuid());
            if (cachedTimestamp != null && cachedTimestamp >= bedrockData.getTimestamp()) {
                return this.callHandlerAndReturnResult(ResultType.TIMESTAMP_DENIED, channel, bedrockData, hostname);
            }
            this.handleCache.put((Object)bedrockData.getXuid(), (Object)bedrockData.getTimestamp());
            LinkedPlayer linkedPlayer = bedrockData.hasPlayerLink() ? bedrockData.getLinkedPlayer() : this.fetchLinkedPlayer(Utils.getJavaUuid(bedrockData.getXuid()));
            HandshakeDataImpl handshakeData = new HandshakeDataImpl(channel, true, bedrockData.clone(), this.configHolder.get(), linkedPlayer != null ? linkedPlayer.clone() : null, hostname);
            if (this.configHolder.get().getPlayerLink().isRequireLink() && linkedPlayer == null) {
                handshakeData.setDisconnectReason("floodgate.core.not_linked");
            }
            this.handshakeHandlers.callHandshakeHandlers(handshakeData);
            if (!handshakeData.shouldDisconnect()) {
                this.skinUploadManager.addConnectionIfNeeded(bedrockData.getSubscribeId(), bedrockData.getVerifyCode());
            }
            this.correctHostname(handshakeData);
            FloodgatePlayerImpl player = FloodgatePlayerImpl.from(bedrockData, handshakeData);
            this.api.addPlayer(player.getJavaUniqueId(), player);
            channel.attr(this.playerAttribute).set((Object)player);
            int port = ((InetSocketAddress)channel.remoteAddress()).getPort();
            InetSocketAddress socketAddress = new InetSocketAddress(handshakeData.getIp(), port);
            player.addProperty(PropertyKey.SOCKET_ADDRESS, socketAddress);
            return new HandshakeResult(ResultType.SUCCESS, handshakeData, bedrockData, player);
        }
        catch (InvalidFormatException formatException) {
            if (formatException.isHeader()) {
                return this.callHandlerAndReturnResult(ResultType.NOT_FLOODGATE_DATA, channel, null, hostname);
            }
            formatException.printStackTrace();
            return this.callHandlerAndReturnResult(ResultType.EXCEPTION, channel, null, hostname);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.callHandlerAndReturnResult(ResultType.EXCEPTION, channel, null, hostname);
        }
    }

    private HandshakeResult callHandlerAndReturnResult(ResultType resultType, Channel channel, BedrockData bedrockData, String hostname) {
        HandshakeDataImpl handshakeData = new HandshakeDataImpl(channel, bedrockData != null, bedrockData, this.configHolder.get(), null, hostname);
        this.handshakeHandlers.callHandshakeHandlers(handshakeData);
        if (bedrockData != null) {
            this.correctHostname(handshakeData);
        }
        return new HandshakeResult(resultType, handshakeData, bedrockData, null);
    }

    private void correctHostname(HandshakeData handshakeData) {
        BedrockData bedrockData = handshakeData.getBedrockData();
        UUID correctUuid = Utils.getJavaUuid(bedrockData.getXuid());
        CharSequence[] split = handshakeData.getHostname().split("\u0000");
        if (split.length >= 3) {
            if (this.logger.isDebug()) {
                this.logger.info("Replacing hostname arg1 '{}' with '{}' and arg2 '{}' with '{}'", new Object[]{split[1], bedrockData.getIp(), split[2], correctUuid.toString()});
            }
            split[1] = bedrockData.getIp();
            split[2] = correctUuid.toString();
        }
        handshakeData.setHostname(String.join((CharSequence)"\u0000", split));
    }

    private LinkedPlayer fetchLinkedPlayer(UUID javaUniqueId) {
        if (!this.api.getPlayerLink().isEnabled()) {
            return null;
        }
        try {
            return (LinkedPlayer)this.api.getPlayerLink().getLinkedPlayer(javaUniqueId).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public FloodgateHandshakeHandler(HandshakeHandlersImpl handshakeHandlers, SimpleFloodgateApi api, FloodgateCipher cipher, FloodgateConfigHolder configHolder, SkinUploadManager skinUploadManager, AttributeKey<FloodgatePlayer> playerAttribute, FloodgateLogger logger) {
        this.handshakeHandlers = handshakeHandlers;
        this.api = api;
        this.cipher = cipher;
        this.configHolder = configHolder;
        this.skinUploadManager = skinUploadManager;
        this.playerAttribute = playerAttribute;
        this.logger = logger;
    }

    public static class HandshakeResult {
        private final ResultType resultType;
        private final HandshakeData handshakeData;
        private final BedrockData bedrockData;
        private final FloodgatePlayer floodgatePlayer;

        public InetSocketAddress getNewIp(Channel channel) {
            if (this.floodgatePlayer != null) {
                return (InetSocketAddress)this.floodgatePlayer.getProperty(PropertyKey.SOCKET_ADDRESS);
            }
            if (this.handshakeData.getIp() != null) {
                int port = ((InetSocketAddress)channel.remoteAddress()).getPort();
                return new InetSocketAddress(this.handshakeData.getIp(), port);
            }
            return null;
        }

        public ResultType getResultType() {
            return this.resultType;
        }

        public HandshakeData getHandshakeData() {
            return this.handshakeData;
        }

        public BedrockData getBedrockData() {
            return this.bedrockData;
        }

        public FloodgatePlayer getFloodgatePlayer() {
            return this.floodgatePlayer;
        }

        protected HandshakeResult(ResultType resultType, HandshakeData handshakeData, BedrockData bedrockData, FloodgatePlayer floodgatePlayer) {
            this.resultType = resultType;
            this.handshakeData = handshakeData;
            this.bedrockData = bedrockData;
            this.floodgatePlayer = floodgatePlayer;
        }
    }

    public static enum ResultType {
        EXCEPTION,
        NOT_FLOODGATE_DATA,
        INVALID_DATA_LENGTH,
        TIMESTAMP_DENIED,
        SUCCESS;

    }
}

