/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.player;

import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.parser.ArgumentParseResult;
import cloud.commandframework.arguments.parser.ArgumentParser;
import cloud.commandframework.context.CommandContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.player.UserAudience;

public final class UserAudienceArgument
extends CommandArgument<UserAudience, UserAudience> {
    private UserAudienceArgument(@NonNull String name, UserAudienceParser parser) {
        super(true, name, (ArgumentParser)parser, UserAudience.class);
    }

    public static UserAudienceArgument of(String name, boolean allowUuid, boolean allowOffline, PlayerType limitTo) {
        return new UserAudienceArgument(name, new UserAudienceParser(allowUuid, allowOffline, limitTo));
    }

    public static UserAudienceArgument of(String name, boolean allowOffline, PlayerType limitTo) {
        return UserAudienceArgument.of(name, false, allowOffline, limitTo);
    }

    public static UserAudienceArgument ofOnline(String name, PlayerType limitTo) {
        return UserAudienceArgument.of(name, false, false, limitTo);
    }

    public static UserAudienceArgument ofOnline(String name, boolean allowUuid) {
        return UserAudienceArgument.of(name, allowUuid, false, PlayerType.ALL_PLAYERS);
    }

    public static CommandArgument<UserAudience, UserAudience> ofOnline(String name) {
        return UserAudienceArgument.of(name, false, false, PlayerType.ALL_PLAYERS);
    }

    public static UserAudienceArgument of(String name, boolean allowOffline) {
        return UserAudienceArgument.of(name, false, allowOffline, PlayerType.ALL_PLAYERS);
    }

    public static final class InvalidPlayerIdentifierException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -6500019324607183855L;

        public InvalidPlayerIdentifierException(@NonNull String message) {
            super(message);
        }

        @Override
        public @NonNull Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class UserAudienceParser
    implements ArgumentParser<UserAudience, UserAudience> {
        private final boolean allowUuid;
        private final boolean allowOffline;
        private final PlayerType limitTo;

        /*
         * Unable to fully structure code
         */
        public @NonNull ArgumentParseResult<UserAudience> parse(@NonNull CommandContext<@NonNull UserAudience> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            commandUtil = (CommandUtil)commandContext.get("CommandUtil");
            input = inputQueue.peek();
            if (input == null || input.length() < 3) {
                return ArgumentParseResult.failure((Throwable)new NullPointerException("Expected player name/UUID"));
            }
            if (input.length() > 16) {
                if (!this.allowUuid) {
                    return ArgumentParseResult.failure((Throwable)new InvalidPlayerIdentifierException("UUID is not allowed here"));
                }
                if (input.length() != 32 && input.length() != 36) {
                    return ArgumentParseResult.failure((Throwable)new InvalidPlayerIdentifierException("Expected player name/UUID"));
                }
                try {
                    uuid = UUID.fromString(input);
                    userAudience = commandUtil.getAudienceByUuid(uuid);
                    if (userAudience != null || !this.allowOffline) ** GOTO lbl21
                    userAudience = commandUtil.getOfflineAudienceByUuid(uuid);
                }
                catch (IllegalArgumentException ignored) {
                    return ArgumentParseResult.failure((Throwable)new InvalidPlayerIdentifierException("Invalid UUID '" + input + "'"));
                }
            } else {
                userAudience = commandUtil.getAudienceByUsername(input);
                if (userAudience == null && this.allowOffline) {
                    userAudience = commandUtil.getOfflineAudienceByUsername(input);
                }
            }
lbl21:
            // 5 sources

            if (userAudience == null) {
                return ArgumentParseResult.failure((Throwable)new InvalidPlayerIdentifierException("Invalid player '" + input + "'"));
            }
            inputQueue.remove();
            return ArgumentParseResult.success((Object)userAudience);
        }

        public @NonNull List<String> suggestions(@NonNull CommandContext<UserAudience> commandContext, @NonNull String input) {
            CommandUtil commandUtil = (CommandUtil)commandContext.get("CommandUtil");
            String trimmedInput = input.trim();
            if (trimmedInput.isEmpty()) {
                return ImmutableList.copyOf(commandUtil.getOnlineUsernames(this.limitTo));
            }
            String lowercaseInput = input.toLowerCase(Locale.ROOT);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String player : commandUtil.getOnlineUsernames(this.limitTo)) {
                if (!player.toLowerCase(Locale.ROOT).startsWith(lowercaseInput)) continue;
                builder.add((Object)player);
            }
            return builder.build();
        }

        public boolean isContextFree() {
            return true;
        }

        public UserAudienceParser(boolean allowUuid, boolean allowOffline, PlayerType limitTo) {
            this.allowUuid = allowUuid;
            this.allowOffline = allowOffline;
            this.limitTo = limitTo;
        }
    }

    public static enum PlayerType {
        ALL_PLAYERS,
        ONLY_BEDROCK,
        ONLY_JAVA;

    }
}

