/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage.channel;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.geysermc.cumulus.Form;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageChannel;

public class FormChannel
implements PluginMessageChannel {
    private final Short2ObjectMap<Form> storedForms = new Short2ObjectOpenHashMap();
    private final AtomicInteger nextFormId = new AtomicInteger(0);
    @Inject
    private PluginMessageUtils pluginMessageUtils;
    @Inject
    private FloodgateConfig config;
    @Inject
    private FloodgateLogger logger;

    @Override
    public String getIdentifier() {
        return "floodgate:form";
    }

    @Override
    public PluginMessageChannel.Result handleProxyCall(byte[] data, UUID targetUuid, String targetUsername, PluginMessageChannel.Identity targetIdentity, UUID sourceUuid, String sourceUsername, PluginMessageChannel.Identity sourceIdentity) {
        if (sourceIdentity == PluginMessageChannel.Identity.SERVER) {
            return PluginMessageChannel.Result.forward();
        }
        if (sourceIdentity == PluginMessageChannel.Identity.PLAYER) {
            if (data.length < 2) {
                return PluginMessageChannel.Result.kick("Invalid form response");
            }
            short formId = this.getFormId(data);
            if ((formId & 0x8000) == 0) {
                return PluginMessageChannel.Result.forward();
            }
            if (!this.callResponseConsumer(data)) {
                this.logger.error("Couldn't find stored form with id {} for player {}", new Object[]{formId, sourceUsername});
            }
        }
        return PluginMessageChannel.Result.handled();
    }

    @Override
    public PluginMessageChannel.Result handleServerCall(byte[] data, UUID targetUuid, String targetUsername) {
        this.callResponseConsumer(data);
        return PluginMessageChannel.Result.handled();
    }

    public boolean sendForm(UUID player, Form form) {
        byte[] formData = this.createFormData(form);
        return this.pluginMessageUtils.sendMessage(player, false, this.getIdentifier(), formData);
    }

    public byte[] createFormData(Form form) {
        short formId = this.getNextFormId();
        if (this.config.isProxy()) {
            formId = (short)(formId | 0x8000);
        }
        this.storedForms.put(formId, (Object)form);
        byte[] jsonData = form.getJsonData().getBytes(Charsets.UTF_8);
        byte[] data = new byte[jsonData.length + 3];
        data[0] = (byte)form.getType().ordinal();
        data[1] = (byte)(formId >> 8 & 0xFF);
        data[2] = (byte)(formId & 0xFF);
        System.arraycopy(jsonData, 0, data, 3, jsonData.length);
        return data;
    }

    protected boolean callResponseConsumer(byte[] data) {
        Form storedForm = (Form)this.storedForms.remove(this.getFormId(data));
        if (storedForm != null) {
            String responseData = new String(data, 2, data.length - 2, Charsets.UTF_8);
            storedForm.getResponseHandler().accept(responseData);
            return true;
        }
        return false;
    }

    protected short getFormId(byte[] data) {
        return (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
    }

    protected short getNextFormId() {
        return (short)this.nextFormId.getAndUpdate(number -> number == Short.MAX_VALUE ? 0 : number + 1);
    }
}

