/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.skin;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinUploadSocket;

public final class SkinUploadManager {
    private final Int2ObjectMap<SkinUploadSocket> connections = new Int2ObjectOpenHashMap();
    private final FloodgateApi api;
    private final SkinApplier applier;
    private final FloodgateLogger logger;

    public void addConnectionIfNeeded(int id, String verifyCode) {
        this.connections.computeIfAbsent(id, ignored -> {
            SkinUploadSocket socket = new SkinUploadSocket(id, verifyCode, this, this.api, this.applier, this.logger);
            socket.connect();
            return socket;
        });
    }

    public void removeConnection(int id, SkinUploadSocket socket) {
        this.connections.remove(id, (Object)socket);
    }

    public SkinUploadManager(FloodgateApi api, SkinApplier applier, FloodgateLogger logger) {
        this.api = api;
        this.applier = applier;
        this.logger = logger;
    }
}

