/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpUtils {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private static final Gson GSON = new Gson();
    private static final String USER_AGENT = "GeyserMC/Floodgate";
    private static final String CONNECTION_STRING = "--";
    private static final String BOUNDARY = "******";
    private static final String END = "\r\n";

    public static CompletableFuture<HttpResponse> asyncGet(String urlString) {
        return CompletableFuture.supplyAsync(() -> HttpUtils.get(urlString), EXECUTOR_SERVICE);
    }

    public static HttpResponse get(String urlString) {
        HttpURLConnection connection;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create connection", exception);
        }
        try {
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", USER_AGENT);
            connection.setRequestProperty("ContentType", "application/json");
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create request", exception);
        }
        return HttpUtils.readResponse(connection);
    }

    private static HttpResponse readResponse(HttpURLConnection connection) {
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
        }
        catch (Exception exception) {
            try {
                stream = connection.getErrorStream();
            }
            catch (Exception exception1) {
                throw new RuntimeException("Both the input and the error stream failed?!");
            }
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        try {
            int responseCode = connection.getResponseCode();
            JsonObject response = (JsonObject)GSON.fromJson((Reader)streamReader, JsonObject.class);
            HttpResponse httpResponse = new HttpResponse(responseCode, response);
            return httpResponse;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read response", exception);
        }
        finally {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final class HttpResponse {
        private final int httpCode;
        private final JsonObject response;

        public int getHttpCode() {
            return this.httpCode;
        }

        public JsonObject getResponse() {
            return this.response;
        }

        private HttpResponse(int httpCode, JsonObject response) {
            this.httpCode = httpCode;
            this.response = response;
        }
    }
}

