/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.InstanceHolder;
import org.geysermc.floodgate.api.handshake.HandshakeHandlers;
import org.geysermc.floodgate.api.inject.PlatformInjector;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.FloodgateConfigHolder;
import org.geysermc.floodgate.config.loader.ConfigLoader;
import org.geysermc.floodgate.link.PlayerLinkLoader;
import org.geysermc.floodgate.module.ConfigLoadedModule;
import org.geysermc.floodgate.module.PostInitializeModule;
import org.geysermc.floodgate.news.NewsChecker;
import org.geysermc.floodgate.util.FloodgateInfoHolder;
import org.geysermc.floodgate.util.GitProperties;
import org.geysermc.floodgate.util.PrefixCheckTask;
import org.geysermc.floodgate.util.TimeSyncerHolder;

public class FloodgatePlatform {
    private static final UUID KEY = UUID.randomUUID();
    private final FloodgateApi api;
    private final PlatformInjector injector;
    private final FloodgateLogger logger;
    private FloodgateConfig config;
    private Injector guice;
    @Inject
    private GitProperties properties;

    @Inject
    public FloodgatePlatform(FloodgateApi api, PlatformInjector platformInjector, FloodgateLogger logger, Injector guice) {
        this.api = api;
        this.injector = platformInjector;
        this.logger = logger;
        this.guice = guice;
    }

    @Inject
    public void init(@Named(value="dataDirectory") Path dataDirectory, ConfigLoader configLoader, FloodgateConfigHolder configHolder, PacketHandlers packetHandlers, HandshakeHandlers handshakeHandlers) {
        if (!Files.isDirectory(dataDirectory, new LinkOption[0])) {
            try {
                Files.createDirectory(dataDirectory, new FileAttribute[0]);
            }
            catch (IOException exception) {
                this.logger.error("Failed to create the data folder", (Throwable)exception, new Object[0]);
                throw new RuntimeException("Failed to create the data folder", exception);
            }
        }
        this.config = configLoader.load();
        if (this.config.isDebug()) {
            this.logger.enableDebug();
        }
        configHolder.set(this.config);
        this.guice = this.guice.createChildInjector(new Module[]{new ConfigLoadedModule(this.config)});
        PlayerLink link = ((PlayerLinkLoader)this.guice.getInstance(PlayerLinkLoader.class)).load();
        TimeSyncerHolder.init();
        InstanceHolder.set((FloodgateApi)this.api, (PlayerLink)link, (PlatformInjector)this.injector, (PacketHandlers)packetHandlers, (HandshakeHandlers)handshakeHandlers, (UUID)KEY);
        FloodgateInfoHolder.setGitProperties((Properties)this.properties.getProperties());
        ((NewsChecker)this.guice.getInstance(NewsChecker.class)).start();
    }

    public boolean enable(Module ... postInitializeModules) {
        if (this.injector == null) {
            this.logger.error("Failed to find the platform injector!", new Object[0]);
            return false;
        }
        try {
            if (!this.injector.inject()) {
                this.logger.error("Failed to inject the packet listener!", new Object[0]);
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.error("Failed to inject the packet listener!", (Throwable)exception, new Object[0]);
            return false;
        }
        this.guice = this.guice.createChildInjector(new Module[]{new PostInitializeModule(postInitializeModules)});
        PrefixCheckTask.checkAndExecuteDelayed(this.config, this.logger);
        return true;
    }

    public boolean disable() {
        if (this.injector != null && this.injector.canRemoveInjection()) {
            try {
                if (!this.injector.removeInjection()) {
                    this.logger.error("Failed to remove the injection!", new Object[0]);
                }
            }
            catch (Exception exception) {
                this.logger.error("Failed to remove the injection!", (Throwable)exception, new Object[0]);
            }
        }
        this.api.getPlayerLink().stop();
        return true;
    }

    public boolean isProxy() {
        return this.config.isProxy();
    }
}

