/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Random;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.api.handshake.HandshakeHandler;
import org.geysermc.floodgate.api.handshake.HandshakeHandlers;

public class HandshakeHandlersImpl
implements HandshakeHandlers {
    private final Random random = new Random();
    private final Int2ObjectMap<HandshakeHandler> handshakeHandlers = new Int2ObjectOpenHashMap();

    public int addHandshakeHandler(HandshakeHandler handshakeHandler) {
        int key;
        if (handshakeHandler == null) {
            return -1;
        }
        while (this.handshakeHandlers.putIfAbsent(key = this.random.nextInt(Integer.MAX_VALUE), (Object)handshakeHandler) != null) {
        }
        return key;
    }

    public void removeHandshakeHandler(int handshakeHandlerId) {
        if (handshakeHandlerId <= 0) {
            return;
        }
        this.handshakeHandlers.remove(handshakeHandlerId);
    }

    public void removeHandshakeHandler(Class<? extends HandshakeHandler> handshakeHandler) {
        if (HandshakeHandler.class == handshakeHandler) {
            return;
        }
        this.handshakeHandlers.values().removeIf(handler -> handler.getClass() == handshakeHandler);
    }

    public void callHandshakeHandlers(HandshakeData handshakeData) {
        for (HandshakeHandler handshakeHandler : this.handshakeHandlers.values()) {
            handshakeHandler.handle(handshakeData);
        }
    }
}

