/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.nio.charset.StandardCharsets;
import org.geysermc.floodgate.addon.debug.ChannelInDebugHandler;
import org.geysermc.floodgate.addon.debug.ChannelOutDebugHandler;
import org.geysermc.floodgate.addon.debug.State;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.util.Utils;

public class StateChangeDetector {
    private static volatile int pluginMessageToClientId = -1;
    private static volatile int pluginMessageToServerId = -1;
    private final Channel channel;
    private final FloodgateLogger logger;
    private final String packetEncoderName;
    private final String packetDecoderName;
    private volatile boolean enableCompressionNext;
    private volatile State currentState = State.HANDSHAKE;

    public StateChangeDetector(Channel channel, String packetEncoderName, String packetDecoderName, FloodgateLogger logger) {
        this.channel = channel;
        this.packetEncoderName = packetEncoderName;
        this.packetDecoderName = packetDecoderName;
        this.logger = logger;
    }

    public void checkPacket(ByteBuf packet, boolean fromClient) {
        int index = packet.readerIndex();
        if (this.enableCompressionNext) {
            Utils.readVarInt(packet);
            this.fixCompressionPipes();
            this.enableCompressionNext = false;
        }
        int packetId = Utils.readVarInt(packet);
        if (fromClient) {
            if (this.currentState == State.HANDSHAKE && packetId == 0) {
                Utils.readVarInt(packet);
                int hostLength = Utils.readVarInt(packet);
                packet.readerIndex(packet.readerIndex() + hostLength + 2);
                this.currentState = State.getById(Utils.readVarInt(packet));
            }
        } else if (this.currentState == State.LOGIN) {
            if (packetId == 2) {
                this.currentState = State.PLAY;
            }
            if (packetId == 3) {
                this.enableCompressionNext = true;
            }
        }
        packet.readerIndex(index);
    }

    private void fixCompressionPipes() {
        ChannelPipeline pipeline = this.channel.pipeline();
        ChannelHandler outDebug = pipeline.remove(ChannelOutDebugHandler.class);
        ChannelHandler inDebug = pipeline.remove(ChannelInDebugHandler.class);
        pipeline.addBefore(this.packetEncoderName, "floodgate_debug_out", outDebug);
        pipeline.addBefore(this.packetDecoderName, "floodgate_debug_in", inDebug);
    }

    public boolean shouldPrintPacket(ByteBuf packet, boolean clientbound) {
        return this.currentState == State.HANDSHAKE || this.currentState == State.LOGIN || this.currentState != State.STATUS && this.shouldPrintPlayPacket(packet, clientbound);
    }

    public boolean shouldPrintPlayPacket(ByteBuf packet, boolean clientbound) {
        int index = packet.readerIndex();
        int packetId = Utils.readVarInt(packet);
        if (clientbound && pluginMessageToClientId != -1) {
            return pluginMessageToClientId == packetId;
        }
        if (!clientbound && pluginMessageToServerId != -1) {
            return pluginMessageToServerId == packetId;
        }
        boolean shouldPrint = false;
        if (packet.isReadable()) {
            try {
                int channelLength = Utils.readVarInt(packet);
                if (channelLength >= 1 && channelLength <= 128 && packet.isReadable(channelLength)) {
                    byte[] channelBytes = new byte[channelLength];
                    packet.readBytes(channelBytes);
                    String channelName = new String(channelBytes, StandardCharsets.UTF_8);
                    if (channelName.contains(":")) {
                        this.printIdentified(clientbound, packetId);
                        if (clientbound) {
                            pluginMessageToClientId = packetId;
                        } else {
                            pluginMessageToServerId = packetId;
                        }
                        shouldPrint = true;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        packet.readerIndex(index);
        return shouldPrint;
    }

    private void printIdentified(boolean clientbound, int packetId) {
        this.logger.info("Identified plugin message packet ({}) as {} ({})", new Object[]{clientbound ? "clientbound" : "serverbound", packetId, Integer.toHexString(packetId)});
    }

    public State getCurrentState() {
        return this.currentState;
    }
}

