/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Command;
import cloud.commandframework.CommandManager;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.context.CommandContext;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.command.CommonCommandMessage;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.player.UserAudienceArgument;
import org.geysermc.floodgate.util.HttpUtils;
import org.geysermc.floodgate.util.Permissions;

public class WhitelistCommand
implements FloodgateCommand {
    @Inject
    private FloodgateConfig config;
    @Inject
    private FloodgateLogger logger;

    @Override
    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        Command.Builder builder = commandManager.commandBuilder("fwhitelist", ArgumentDescription.of((String)"Easy way to whitelist Bedrock players"), new String[0]).permission(Permissions.COMMAND_WHITELIST.get());
        commandManager.command(builder.literal("add", new String[]{"a"}).argument((CommandArgument)UserAudienceArgument.of("player", true)).handler(context -> this.performCommand((CommandContext<UserAudience>)context, true)));
        return builder.literal("remove", new String[]{"r"}).argument((CommandArgument)UserAudienceArgument.of("player", true)).handler(context -> this.performCommand((CommandContext<UserAudience>)context, false)).build();
    }

    public void performCommand(CommandContext<UserAudience> context, boolean add) {
        UserAudience sender = (UserAudience)context.getSender();
        UserAudience player = (UserAudience)context.get("player");
        String name = player.username();
        if (name.startsWith(this.config.getUsernamePrefix())) {
            name = name.substring(this.config.getUsernamePrefix().length());
        }
        if (name.length() < 1 || name.length() > 16) {
            sender.sendMessage(Message.INVALID_USERNAME, new Object[0]);
            return;
        }
        String tempName = name;
        if (this.config.isReplaceSpaces()) {
            tempName = tempName.replace(' ', '_');
        }
        String correctName = this.config.getUsernamePrefix() + tempName;
        String strippedName = name;
        HttpUtils.asyncGet("https://api.geysermc.org/v1/xbox/xuid/" + name).whenComplete((result, error) -> {
            if (error != null) {
                sender.sendMessage(Message.API_UNAVAILABLE, new Object[0]);
                error.printStackTrace();
                return;
            }
            JsonObject response = (JsonObject)result.getResponse();
            boolean success = response.get("success").getAsBoolean();
            if (!success) {
                sender.sendMessage(Message.UNEXPECTED_ERROR, new Object[0]);
                this.logger.error("Got an error from requesting the xuid of a Bedrock player: {}", new Object[]{response.get("message").getAsString()});
                return;
            }
            JsonObject data = response.getAsJsonObject("data");
            if (data.size() == 0) {
                sender.sendMessage(Message.USER_NOT_FOUND, new Object[0]);
                return;
            }
            String xuid = data.get("xuid").getAsString();
            CommandUtil commandUtil = (CommandUtil)context.get("CommandUtil");
            try {
                if (add) {
                    if (commandUtil.whitelistPlayer(xuid, correctName)) {
                        sender.sendMessage(Message.PLAYER_ADDED, strippedName);
                    } else {
                        sender.sendMessage(Message.PLAYER_ALREADY_WHITELISTED, strippedName);
                    }
                } else if (commandUtil.removePlayerFromWhitelist(xuid, correctName)) {
                    sender.sendMessage(Message.PLAYER_REMOVED, strippedName);
                } else {
                    sender.sendMessage(Message.PLAYER_NOT_WHITELISTED, strippedName);
                }
            }
            catch (Exception exception) {
                this.logger.error("An unexpected error happened while executing the whitelist command", (Throwable)exception, new Object[0]);
            }
        });
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
    }

    @Override
    public boolean shouldRegister(FloodgateConfig config) {
        return !(config instanceof ProxyFloodgateConfig);
    }

    public static enum Message implements TranslatableMessage
    {
        INVALID_USERNAME("floodgate.command.fwhitelist.invalid_username"),
        API_UNAVAILABLE("floodgate.command.fwhitelist.api_unavailable " + CommonCommandMessage.CHECK_CONSOLE),
        USER_NOT_FOUND("floodgate.command.fwhitelist.user_not_found"),
        PLAYER_ADDED("floodgate.command.fwhitelist.player_added"),
        PLAYER_REMOVED("floodgate.command.fwhitelist.player_removed"),
        PLAYER_ALREADY_WHITELISTED("floodgate.command.fwhitelist.player_already_whitelisted"),
        PLAYER_NOT_WHITELISTED("floodgate.command.fwhitelist.player_not_whitelisted"),
        UNEXPECTED_ERROR("floodgate.command.fwhitelist.unexpected_error " + CommonCommandMessage.CHECK_CONSOLE);

        private final String rawMessage;
        private final String[] translateParts;

        private Message(String rawMessage) {
            this.rawMessage = rawMessage;
            this.translateParts = rawMessage.split(" ");
        }

        @Override
        public String getRawMessage() {
            return this.rawMessage;
        }

        @Override
        public String[] getTranslateParts() {
            return this.translateParts;
        }
    }
}

