/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.config.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.geysermc.floodgate.util.MessageFormatter;
import org.geysermc.floodgate.util.Utils;

public class DefaultConfigHandler {
    public void createDefaultConfig(String defaultConfigLocation, Path configPath) throws IOException {
        List<String> configLines = this.loadDefaultConfig(defaultConfigLocation);
        Files.write(configPath, configLines, new OpenOption[0]);
    }

    public List<String> loadDefaultConfig(String defaultConfigLocation) throws IOException {
        List<String> lines = Utils.readAllLines(defaultConfigLocation);
        ArrayList<String> configLines = new ArrayList<String>();
        String parentConfig = null;
        List<String> parentLines = null;
        int lastInsertLine = -1;
        int tempAddAfter = -1;
        for (String line : lines) {
            if (line.startsWith(">>")) {
                if (line.length() >= 3) {
                    if (line.charAt(2) == ' ') {
                        if (tempAddAfter != -1) {
                            throw new IllegalStateException("Cannot define new parent without closing the current section");
                        }
                        parentConfig = line.substring(3);
                        parentLines = null;
                        lastInsertLine = -1;
                        continue;
                    }
                    if (line.charAt(2) == '|') {
                        int i;
                        if (line.length() == 3) {
                            if (tempAddAfter == -1) {
                                throw new IllegalStateException("Cannot close an unclosed section");
                            }
                            lastInsertLine = tempAddAfter;
                            tempAddAfter = -1;
                            continue;
                        }
                        if (parentConfig == null) {
                            throw new IllegalStateException("Cannot start insert section without providing a parent");
                        }
                        if (tempAddAfter != -1) {
                            throw new IllegalStateException("Cannot start section with an unclosed section");
                        }
                        int addAfter = Integer.parseInt(line.substring(4)) - 1;
                        if (lastInsertLine > -1 && addAfter < lastInsertLine) {
                            throw new IllegalStateException(MessageFormatter.format("Cannot add the same lines twice {} {}", addAfter, lastInsertLine));
                        }
                        if (lastInsertLine == -1) {
                            parentLines = Utils.readAllLines(parentConfig);
                            for (i = 0; i <= addAfter; ++i) {
                                configLines.add(parentLines.get(i));
                            }
                        } else {
                            for (i = lastInsertLine; i <= addAfter; ++i) {
                                configLines.add(parentLines.get(i));
                            }
                        }
                        tempAddAfter = addAfter;
                        continue;
                    }
                    if (line.charAt(2) == '*') {
                        if (parentConfig == null) {
                            throw new IllegalStateException("Cannot write rest of the parent without providing a parent");
                        }
                        if (tempAddAfter != -1) {
                            throw new IllegalStateException("Cannot write rest of the parent config while an insert section is still open");
                        }
                        if (lastInsertLine == -1) {
                            parentLines = Utils.readAllLines(parentConfig);
                            configLines.addAll(parentLines);
                            continue;
                        }
                        for (int i = lastInsertLine + 1; i < parentLines.size(); ++i) {
                            configLines.add(parentLines.get(i));
                        }
                        continue;
                    }
                    throw new IllegalStateException("The use of >>" + line.charAt(2) + " is unknown");
                }
                throw new IllegalStateException("Unable do something with just >>");
            }
            configLines.add(line);
        }
        return configLines;
    }
}

