/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.config.updater;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.loader.ConfigLoader;
import org.geysermc.floodgate.config.updater.ConfigFileUpdater;
import org.geysermc.floodgate.util.MessageFormatter;
import org.yaml.snakeyaml.Yaml;

public final class ConfigUpdater {
    private static final int CONFIG_VERSION = 2;
    private final Path dataFolder;
    private final ConfigFileUpdater fileUpdater;
    private final FloodgateLogger logger;

    public void update(ConfigLoader loader, String defaultConfigLocation) {
        Map config;
        Path configLocation = this.dataFolder.resolve("config.yml");
        try (BufferedReader configReader = Files.newBufferedReader(configLocation);){
            config = (Map)new Yaml().load((Reader)configReader);
        }
        catch (IOException exception) {
            this.logger.error("Error while opening the config file", (Throwable)exception, new Object[0]);
            throw new RuntimeException("Failed to update config", exception);
        }
        HashMap<String, String> renames = new HashMap<String, String>();
        int version = 0;
        Object versionElement = config.get("config-version");
        if (versionElement == null) {
            this.logger.warn("We've detected a pre-rewrite config file, please note that Floodgate doesn't not work properly if you don't update your Floodgate key used on all your servers (including Geyser). We'll try to update your Floodgate config now and we'll also generate a new Floodgate key for you, but if you're running a network or if you're running a Spigot server with Geyser Standalone please update as you'll no longer be able to connect.", new Object[0]);
            renames.put("enabled", "enable");
            renames.put("allowed", "allow-linking");
            Path keyFilePath = this.dataFolder.resolve((String)config.get("key-file-name"));
            if (Files.exists(keyFilePath, new LinkOption[0])) {
                try {
                    Files.copy(keyFilePath, this.dataFolder.resolve("old-key.pem"), new CopyOption[0]);
                }
                catch (IOException exception) {
                    throw new RuntimeException("Failed to relocate the old key to make place for a new key", exception);
                }
            }
            loader.generateKey(keyFilePath);
        } else {
            Preconditions.checkArgument((boolean)(versionElement instanceof Integer), (Object)"Config version should be an integer. Did someone mess with the config?");
            version = (Integer)versionElement;
            Preconditions.checkArgument((version > 0 && version <= 2 ? 1 : 0) != 0, (Object)MessageFormatter.format("Config is newer then possible on this version! Expected {}, got {}", 2, version));
        }
        if (version == 2) {
            return;
        }
        if (version < 2) {
            renames.put("enable-global-linking", "use-global-linking");
        }
        try {
            this.fileUpdater.update(configLocation, config, renames, defaultConfigLocation);
        }
        catch (IOException exception) {
            this.logger.error("Error while updating the config file", (Throwable)exception, new Object[0]);
            throw new RuntimeException("Failed to update config", exception);
        }
    }

    public ConfigUpdater(Path dataFolder, ConfigFileUpdater fileUpdater, FloodgateLogger logger) {
        this.dataFolder = dataFolder;
        this.fileUpdater = fileUpdater;
        this.logger = logger;
    }
}

