/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.link.LinkRequest;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.database.config.DatabaseConfig;
import org.geysermc.floodgate.database.config.DatabaseConfigLoader;
import org.geysermc.floodgate.util.InjectorHolder;

public abstract class CommonPlayerLink
implements PlayerLink {
    private final ExecutorService executorService = Executors.newFixedThreadPool(11);
    private boolean enabled;
    private boolean allowLinking;
    private long verifyLinkTimeout;
    @Inject
    private FloodgateLogger logger;
    @Inject
    private FloodgateApi api;
    @Inject
    private InjectorHolder injectorHolder;

    @Inject
    private void init(FloodgateConfig config) {
        FloodgateConfig.PlayerLinkConfig linkConfig = config.getPlayerLink();
        this.enabled = linkConfig.isEnabled();
        this.allowLinking = linkConfig.isAllowed();
        this.verifyLinkTimeout = linkConfig.getLinkCodeTimeout();
    }

    public String createCode() {
        return String.format("%04d", new Random().nextInt(10000));
    }

    public boolean isRequestedPlayer(LinkRequest request, UUID bedrockId) {
        return request.isRequestedPlayer(this.api.getPlayer(bedrockId));
    }

    public <T extends DatabaseConfig> T getConfig(Class<T> configClass) {
        return ((DatabaseConfigLoader)this.injectorHolder.get().getInstance(DatabaseConfigLoader.class)).loadAs(configClass);
    }

    public String getName() {
        return (String)this.injectorHolder.get().getInstance(Key.get(String.class, (Annotation)Names.named((String)"databaseName")));
    }

    public void stop() {
        this.executorService.shutdown();
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public long getVerifyLinkTimeout() {
        return this.verifyLinkTimeout;
    }

    protected FloodgateLogger getLogger() {
        return this.logger;
    }

    protected FloodgateApi getApi() {
        return this.api;
    }
}

