/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.link;

import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.link.LinkRequestResult;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.link.CommonPlayerLink;
import org.geysermc.floodgate.util.HttpUtils;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.Utils;

public class GlobalPlayerLinking
extends CommonPlayerLink {
    private static final String GET_BEDROCK_LINK = "https://api.geysermc.org/v1/link/bedrock/";
    private PlayerLink databaseImpl;

    public void setDatabaseImpl(PlayerLink databaseImpl) {
        if (this.databaseImpl == null) {
            this.databaseImpl = databaseImpl;
        }
    }

    public void load() {
        if (this.databaseImpl != null) {
            this.databaseImpl.load();
        }
    }

    @Override
    public String getName() {
        if (this.databaseImpl != null) {
            return this.databaseImpl.getName();
        }
        return null;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.databaseImpl != null) {
            this.databaseImpl.stop();
        }
    }

    public @NonNull CompletableFuture<LinkedPlayer> getLinkedPlayer(@NonNull UUID bedrockId) {
        if (this.databaseImpl == null) {
            return this.getLinkedPlayer0(bedrockId);
        }
        return this.databaseImpl.getLinkedPlayer(bedrockId).thenComposeAsync(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.getLinkedPlayer0(bedrockId);
        });
    }

    private @NonNull CompletableFuture<LinkedPlayer> getLinkedPlayer0(@NonNull UUID bedrockId) {
        return CompletableFuture.supplyAsync(() -> {
            HttpUtils.DefaultHttpResponse response = HttpUtils.get(GET_BEDROCK_LINK + bedrockId.getLeastSignificantBits());
            if (!((JsonObject)response.getResponse()).get("success").getAsBoolean()) {
                this.getLogger().error("Failed to request link for {}: {}", new Object[]{bedrockId.getLeastSignificantBits(), ((JsonObject)response.getResponse()).get("message").getAsString()});
                return null;
            }
            JsonObject data = ((JsonObject)response.getResponse()).getAsJsonObject("data");
            if (data.size() == 0) {
                return null;
            }
            return LinkedPlayer.of((String)data.get("java_name").getAsString(), (UUID)UUID.fromString(data.get("java_id").getAsString()), (UUID)Utils.getJavaUuid(data.get("bedrock_id").getAsLong()));
        }, this.getExecutorService());
    }

    public @NonNull CompletableFuture<Boolean> isLinkedPlayer(@NonNull UUID bedrockId) {
        if (this.databaseImpl == null) {
            return this.isLinkedPlayer0(bedrockId);
        }
        return this.databaseImpl.isLinkedPlayer(bedrockId).thenComposeAsync(result -> {
            if (result != null) {
                return CompletableFuture.completedFuture(result);
            }
            return this.isLinkedPlayer0(bedrockId);
        });
    }

    private @NonNull CompletableFuture<Boolean> isLinkedPlayer0(@NonNull UUID bedrockId) {
        return CompletableFuture.supplyAsync(() -> {
            HttpUtils.DefaultHttpResponse response = HttpUtils.get(GET_BEDROCK_LINK + bedrockId.getLeastSignificantBits());
            if (!((JsonObject)response.getResponse()).get("success").getAsBoolean()) {
                this.getLogger().error("Failed to request link for {}: {}", new Object[]{bedrockId.getLeastSignificantBits(), ((JsonObject)response.getResponse()).get("message").getAsString()});
                return false;
            }
            JsonObject data = ((JsonObject)response.getResponse()).getAsJsonObject("data");
            return data.size() != 0;
        }, this.getExecutorService());
    }

    public @NonNull CompletableFuture<Void> linkPlayer(@NonNull UUID bedrockId, @NonNull UUID javaId, @NonNull String username) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.linkPlayer(bedrockId, javaId, username);
        }
        return this.failedFuture();
    }

    public @NonNull CompletableFuture<Void> unlinkPlayer(@NonNull UUID javaId) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.unlinkPlayer(javaId);
        }
        return this.failedFuture();
    }

    public @NonNull CompletableFuture<?> createLinkRequest(@NonNull UUID javaId, @NonNull String javaUsername, @NonNull String bedrockUsername) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.createLinkRequest(javaId, javaUsername, bedrockUsername);
        }
        return this.failedFuture();
    }

    public @NonNull CompletableFuture<LinkRequestResult> verifyLinkRequest(@NonNull UUID bedrockId, @NonNull String javaUsername, @NonNull String bedrockUsername, @NonNull String code) {
        if (this.databaseImpl != null) {
            return this.databaseImpl.verifyLinkRequest(bedrockId, javaUsername, bedrockUsername, code);
        }
        return this.failedFuture();
    }

    public boolean isEnabledAndAllowed() {
        return this.databaseImpl != null && this.databaseImpl.isEnabledAndAllowed();
    }

    private <U> CompletableFuture<U> failedFuture() {
        return Utils.failedFuture(new IllegalStateException("Cannot perform this action when Global Linking is enabled"));
    }

    public PlayerLink getDatabaseImpl() {
        return this.databaseImpl;
    }
}

