/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.MessageFormatter;

public final class JavaUtilFloodgateLogger
implements FloodgateLogger {
    private final Logger logger;
    private final LanguageManager languageManager;
    private Level originLevel;

    public void error(String message, Object ... args) {
        this.logger.severe(MessageFormatter.format(message, args));
    }

    public void error(String message, Throwable throwable, Object ... args) {
        this.logger.log(Level.SEVERE, MessageFormatter.format(message, args), throwable);
    }

    public void warn(String message, Object ... args) {
        this.logger.warning(MessageFormatter.format(message, args));
    }

    public void info(String message, Object ... args) {
        this.logger.info(MessageFormatter.format(message, args));
    }

    public void translatedInfo(String message, Object ... args) {
        this.logger.info(this.languageManager.getLogString(message, args));
    }

    public void debug(String message, Object ... args) {
        this.logger.fine(MessageFormatter.format(message, args));
    }

    public void trace(String message, Object ... args) {
        this.logger.finer(MessageFormatter.format(message, args));
    }

    public void enableDebug() {
        this.originLevel = this.logger.getLevel();
        this.logger.setLevel(Level.ALL);
    }

    public void disableDebug() {
        if (this.originLevel != null) {
            this.logger.setLevel(this.originLevel);
        }
    }

    public boolean isDebug() {
        return this.logger.getLevel() == Level.ALL;
    }

    public JavaUtilFloodgateLogger(Logger logger, LanguageManager languageManager) {
        this.logger = logger;
        this.languageManager = languageManager;
    }
}

