/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.news;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.geysermc.floodgate.api.link.PlayerLink;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.news.NewsItem;
import org.geysermc.floodgate.news.NewsItemAction;
import org.geysermc.floodgate.news.NewsType;
import org.geysermc.floodgate.news.data.BuildSpecificData;
import org.geysermc.floodgate.news.data.CheckAfterData;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.util.HttpUtils;
import org.geysermc.floodgate.util.Permissions;

public class NewsChecker {
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private final PlayerLink link;
    private final CommandUtil commandUtil;
    private final FloodgateLogger logger;
    private final Map<Integer, NewsItem> activeNewsItems = new HashMap<Integer, NewsItem>();
    private final String branch;
    private final int build;
    private boolean firstCheck;

    public NewsChecker(PlayerLink link, CommandUtil commandUtil, FloodgateLogger logger, String branch, int build) {
        this.link = link;
        this.commandUtil = commandUtil;
        this.logger = logger;
        this.branch = branch;
        this.build = build;
    }

    public void start() {
        this.executorService.scheduleWithFixedDelay(this::checkNews, 0L, 30L, TimeUnit.MINUTES);
    }

    private void schedule(long delayMs) {
        this.executorService.schedule(this::checkNews, delayMs, TimeUnit.MILLISECONDS);
    }

    private void checkNews() {
        block4: {
            HttpUtils.HttpResponse<JsonArray> response = HttpUtils.getSilent("https://api.geysermc.org/v1/news", JsonArray.class);
            JsonArray array = response.getResponse();
            if (array == null) {
                return;
            }
            try {
                for (JsonElement newsItemElement : array) {
                    NewsItem newsItem = NewsItem.readItem((JsonObject)newsItemElement.getAsJsonObject());
                    if (newsItem == null) continue;
                    this.addNews(newsItem);
                }
                this.firstCheck = false;
            }
            catch (Exception e) {
                if (!this.logger.isDebug()) break block4;
                this.logger.error("Error while reading news item", (Throwable)e, new Object[0]);
            }
        }
    }

    public void handleNews(Object player, NewsItemAction action) {
        for (NewsItem news : this.getActiveNews(action)) {
            this.handleNewsItem(player, news, action);
        }
    }

    private void handleNewsItem(Object player, NewsItem news, NewsItemAction action) {
        switch (action) {
            case ON_SERVER_STARTED: {
                if (!this.firstCheck) {
                    return;
                }
            }
            case BROADCAST_TO_CONSOLE: {
                this.logger.info(news.getMessage(), new Object[0]);
                break;
            }
            case ON_OPERATOR_JOIN: {
                if (player == null) {
                    return;
                }
                if (!this.commandUtil.hasPermission(player, Permissions.NEWS_RECEIVE.get())) break;
                String message = "\u00a7a " + news.getMessage();
                this.commandUtil.sendMessage(player, message);
                break;
            }
            case BROADCAST_TO_OPERATORS: {
                Collection<Object> onlinePlayers = this.commandUtil.getOnlinePlayersWithPermission(Permissions.NEWS_RECEIVE.get());
                for (Object onlinePlayer : onlinePlayers) {
                    String message = "\u00a7a " + news.getMessage();
                    this.commandUtil.sendMessage(onlinePlayer, message);
                }
                break;
            }
        }
    }

    public Collection<NewsItem> getActiveNews() {
        return this.activeNewsItems.values();
    }

    public Collection<NewsItem> getActiveNews(NewsItemAction action) {
        ArrayList<NewsItem> news = new ArrayList<NewsItem>();
        for (NewsItem item : this.getActiveNews()) {
            if (!item.getActions().contains(action)) continue;
            news.add(item);
        }
        return news;
    }

    public void addNews(NewsItem item) {
        if (this.activeNewsItems.containsKey(item.getId())) {
            if (!item.isActive()) {
                this.activeNewsItems.remove(item.getId());
            }
            return;
        }
        if (!item.isActive()) {
            return;
        }
        if (!item.isGlobal() && !"floodgate".equals(item.getProject())) {
            if (this.link.getName() == null) {
                return;
            }
            String fullDatabaseName = "floodgate/" + this.link.getName();
            if (!fullDatabaseName.equals(item.getProject())) {
                return;
            }
        }
        if (item.getType() == NewsType.BUILD_SPECIFIC) {
            if (!((BuildSpecificData)item.getDataAs(BuildSpecificData.class)).isAffected(this.branch, this.build)) {
                return;
            }
        } else if (item.getType() == NewsType.CHECK_AFTER) {
            long checkAfter = ((CheckAfterData)item.getDataAs(CheckAfterData.class)).getCheckAfter();
            long delayMs = System.currentTimeMillis() - checkAfter;
            this.schedule(delayMs > 0L ? delayMs : 0L);
        }
        this.activeNewsItems.put(item.getId(), item);
        this.activateNews(item);
    }

    private void activateNews(NewsItem item) {
        for (NewsItemAction action : item.getActions()) {
            this.handleNewsItem(null, item, action);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

