/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.player;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.InstanceHolder;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.api.player.PropertyKey;
import org.geysermc.floodgate.time.TimeSyncer;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.floodgate.util.InputMode;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.TimeSyncerHolder;
import org.geysermc.floodgate.util.UiProfile;
import org.geysermc.floodgate.util.Utils;

public final class FloodgatePlayerImpl
implements FloodgatePlayer {
    private final String version;
    private final String username;
    private final String javaUsername;
    private final UUID javaUniqueId;
    private final String xuid;
    private final DeviceOs deviceOs;
    private final String languageCode;
    private final UiProfile uiProfile;
    private final InputMode inputMode;
    private final String ip;
    private final boolean fromProxy;
    private final boolean proxy;
    private final LinkedPlayer linkedPlayer;
    private final int subscribeId;
    private final String verifyCode;
    public Map<PropertyKey, Object> propertyKeyToValue;
    private Map<String, PropertyKey> stringToPropertyKey;
    private boolean login = true;

    protected static FloodgatePlayerImpl from(BedrockData data, HandshakeData handshakeData) {
        FloodgateApi api = InstanceHolder.getApi();
        UUID javaUniqueId = Utils.getJavaUuid(data.getXuid());
        DeviceOs deviceOs = DeviceOs.getById((int)data.getDeviceOs());
        UiProfile uiProfile = UiProfile.getById((int)data.getUiProfile());
        InputMode inputMode = InputMode.getById((int)data.getInputMode());
        LinkedPlayer linkedPlayer = handshakeData.getLinkedPlayer();
        return new FloodgatePlayerImpl(data.getVersion(), data.getUsername(), handshakeData.getJavaUsername(), javaUniqueId, data.getXuid(), deviceOs, data.getLanguageCode(), uiProfile, inputMode, data.getIp(), data.isFromProxy(), api instanceof ProxyFloodgateApi, linkedPlayer, data.getSubscribeId(), data.getVerifyCode());
    }

    public UUID getCorrectUniqueId() {
        return this.linkedPlayer != null ? this.linkedPlayer.getJavaUniqueId() : this.javaUniqueId;
    }

    public String getCorrectUsername() {
        return this.linkedPlayer != null ? this.linkedPlayer.getJavaUsername() : this.javaUsername;
    }

    public BedrockData toBedrockData() {
        TimeSyncer timeSyncer = TimeSyncerHolder.get();
        return BedrockData.of((String)this.version, (String)this.username, (String)this.xuid, (int)this.deviceOs.ordinal(), (String)this.languageCode, (int)this.uiProfile.ordinal(), (int)this.inputMode.ordinal(), (String)this.ip, (LinkedPlayer)this.linkedPlayer, (boolean)this.proxy, (int)this.subscribeId, (String)this.verifyCode, (TimeSyncer)timeSyncer);
    }

    public boolean hasProperty(PropertyKey key) {
        if (this.propertyKeyToValue == null) {
            return false;
        }
        return this.propertyKeyToValue.get(key) != null;
    }

    public boolean hasProperty(String key) {
        if (this.stringToPropertyKey == null) {
            return false;
        }
        return this.hasProperty(this.stringToPropertyKey.get(key));
    }

    public <T> T getProperty(PropertyKey key) {
        if (this.propertyKeyToValue == null) {
            return null;
        }
        return (T)this.propertyKeyToValue.get(key);
    }

    public <T> T getProperty(String key) {
        if (this.stringToPropertyKey == null) {
            return null;
        }
        return this.getProperty(this.stringToPropertyKey.get(key));
    }

    public <T> T removeProperty(String key) {
        if (this.stringToPropertyKey == null) {
            return null;
        }
        PropertyKey propertyKey = this.stringToPropertyKey.get(key);
        if (propertyKey == null || !propertyKey.isRemovable()) {
            return null;
        }
        return (T)this.propertyKeyToValue.remove(propertyKey);
    }

    public <T> T removeProperty(PropertyKey key) {
        if (this.stringToPropertyKey == null) {
            return null;
        }
        PropertyKey propertyKey = this.stringToPropertyKey.get(key.getKey());
        if (propertyKey == null || !propertyKey.equals(key) || !propertyKey.isRemovable()) {
            return null;
        }
        this.stringToPropertyKey.remove(key.getKey());
        return (T)this.propertyKeyToValue.remove(key);
    }

    public <T> T addProperty(PropertyKey key, Object value) {
        if (this.stringToPropertyKey == null) {
            this.stringToPropertyKey = new HashMap<String, PropertyKey>();
            this.propertyKeyToValue = new HashMap<PropertyKey, Object>();
            this.stringToPropertyKey.put(key.getKey(), key);
            this.propertyKeyToValue.put(key, value);
            return null;
        }
        PropertyKey propertyKey = this.stringToPropertyKey.get(key.getKey());
        if (propertyKey != null && propertyKey.isAddAllowed((Object)key) == PropertyKey.Result.ALLOWED) {
            this.stringToPropertyKey.put(key.getKey(), key);
            return (T)this.propertyKeyToValue.put(key, value);
        }
        return (T)this.stringToPropertyKey.computeIfAbsent(key.getKey(), keyString -> {
            this.propertyKeyToValue.put(key, value);
            return key;
        });
    }

    public <T> T addProperty(String key, Object value) {
        PropertyKey propertyKey = new PropertyKey(key, true, true);
        if (this.stringToPropertyKey == null) {
            this.stringToPropertyKey = new HashMap<String, PropertyKey>();
            this.propertyKeyToValue = new HashMap<PropertyKey, Object>();
            this.stringToPropertyKey.put(key, propertyKey);
            this.propertyKeyToValue.put(propertyKey, value);
            return null;
        }
        PropertyKey currentPropertyKey = this.stringToPropertyKey.get(key);
        if (currentPropertyKey != null && currentPropertyKey.isAddAllowed((Object)key) == PropertyKey.Result.ALLOWED) {
            this.stringToPropertyKey.put(key, propertyKey);
            return (T)this.propertyKeyToValue.put(propertyKey, value);
        }
        return (T)this.stringToPropertyKey.computeIfAbsent(key, keyString -> {
            this.propertyKeyToValue.put(propertyKey, value);
            return propertyKey;
        });
    }

    public String getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public String getJavaUsername() {
        return this.javaUsername;
    }

    public UUID getJavaUniqueId() {
        return this.javaUniqueId;
    }

    public String getXuid() {
        return this.xuid;
    }

    public DeviceOs getDeviceOs() {
        return this.deviceOs;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public UiProfile getUiProfile() {
        return this.uiProfile;
    }

    public InputMode getInputMode() {
        return this.inputMode;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean isFromProxy() {
        return this.fromProxy;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public LinkedPlayer getLinkedPlayer() {
        return this.linkedPlayer;
    }

    public int getSubscribeId() {
        return this.subscribeId;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public boolean isLogin() {
        return this.login;
    }

    private FloodgatePlayerImpl(String version, String username, String javaUsername, UUID javaUniqueId, String xuid, DeviceOs deviceOs, String languageCode, UiProfile uiProfile, InputMode inputMode, String ip, boolean fromProxy, boolean proxy, LinkedPlayer linkedPlayer, int subscribeId, String verifyCode) {
        this.version = version;
        this.username = username;
        this.javaUsername = javaUsername;
        this.javaUniqueId = javaUniqueId;
        this.xuid = xuid;
        this.deviceOs = deviceOs;
        this.languageCode = languageCode;
        this.uiProfile = uiProfile;
        this.inputMode = inputMode;
        this.ip = ip;
        this.fromProxy = fromProxy;
        this.proxy = proxy;
        this.linkedPlayer = linkedPlayer;
        this.subscribeId = subscribeId;
        this.verifyCode = verifyCode;
    }

    private Map<PropertyKey, Object> getPropertyKeyToValue() {
        return this.propertyKeyToValue;
    }

    private Map<String, PropertyKey> getStringToPropertyKey() {
        return this.stringToPropertyKey;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }
}

