/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpUtils {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private static final Gson GSON = new Gson();
    private static final String USER_AGENT = "GeyserMC/Floodgate";
    private static final String CONNECTION_STRING = "--";
    private static final String BOUNDARY = "******";
    private static final String END = "\r\n";

    public static CompletableFuture<DefaultHttpResponse> asyncGet(String urlString) {
        return CompletableFuture.supplyAsync(() -> HttpUtils.get(urlString), EXECUTOR_SERVICE);
    }

    public static DefaultHttpResponse get(String urlString) {
        return HttpUtils.readDefaultResponse(HttpUtils.request(urlString));
    }

    public static <T> HttpResponse<T> getSilent(String urlString, Class<T> clazz) {
        return HttpUtils.readResponseSilent(HttpUtils.request(urlString), clazz);
    }

    private static HttpURLConnection request(String urlString) {
        HttpURLConnection connection;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection)url.openConnection();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create connection", exception);
        }
        try {
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setRequestProperty("User-Agent", USER_AGENT);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create request", exception);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> HttpResponse<T> readResponseSilent(HttpURLConnection connection, Class<T> clazz) {
        InputStreamReader streamReader = HttpUtils.createReader(connection);
        try {
            int responseCode = connection.getResponseCode();
            Object response = GSON.fromJson((Reader)streamReader, clazz);
            HttpResponse httpResponse = new HttpResponse(responseCode, response);
            return httpResponse;
        }
        catch (Exception ignored) {
            HttpResponse httpResponse = new HttpResponse(-1, null);
            return httpResponse;
        }
        finally {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private static DefaultHttpResponse readDefaultResponse(HttpURLConnection connection) {
        InputStreamReader streamReader = HttpUtils.createReader(connection);
        try {
            int responseCode = connection.getResponseCode();
            JsonObject response = (JsonObject)GSON.fromJson((Reader)streamReader, JsonObject.class);
            DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(responseCode, response);
            return defaultHttpResponse;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read response", exception);
        }
        finally {
            try {
                streamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    private static InputStreamReader createReader(HttpURLConnection connection) {
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
        }
        catch (Exception exception) {
            try {
                stream = connection.getErrorStream();
            }
            catch (Exception exception1) {
                throw new RuntimeException("Both the input and the error stream failed?!");
            }
        }
        return new InputStreamReader(stream);
    }

    public static final class DefaultHttpResponse
    extends HttpResponse<JsonObject> {
        private DefaultHttpResponse(int httpCode, JsonObject response) {
            super(httpCode, response);
        }
    }

    public static class HttpResponse<T> {
        private final int httpCode;
        private final T response;

        public int getHttpCode() {
            return this.httpCode;
        }

        public T getResponse() {
            return this.response;
        }

        private HttpResponse(int httpCode, T response) {
            this.httpCode = httpCode;
            this.response = response;
        }
    }
}

