/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.geysermc.floodgate.SpigotPlatform;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.module.PluginMessageModule;
import org.geysermc.floodgate.module.ServerCommonModule;
import org.geysermc.floodgate.module.SpigotAddonModule;
import org.geysermc.floodgate.module.SpigotCommandModule;
import org.geysermc.floodgate.module.SpigotListenerModule;
import org.geysermc.floodgate.module.SpigotPlatformModule;
import org.geysermc.floodgate.util.SpigotProtocolSupportHandler;
import org.geysermc.floodgate.util.SpigotProtocolSupportListener;

public final class SpigotPlugin
extends JavaPlugin {
    private SpigotPlatform platform;
    private Injector injector;

    public void onLoad() {
        long ctm = System.currentTimeMillis();
        this.injector = Guice.createInjector((Module[])new Module[]{new ServerCommonModule(this.getDataFolder().toPath()), new SpigotPlatformModule(this)});
        this.platform = (SpigotPlatform)((Object)this.injector.getInstance(SpigotPlatform.class));
        long endCtm = System.currentTimeMillis();
        ((FloodgateLogger)this.injector.getInstance(FloodgateLogger.class)).translatedInfo("floodgate.core.finish", new Object[]{endCtm - ctm});
    }

    public void onEnable() {
        this.platform.enable(new Module[]{new SpigotCommandModule(this), new SpigotListenerModule(), new SpigotAddonModule(), new PluginMessageModule()});
        if (this.getServer().getPluginManager().getPlugin("ProtocolSupport") != null) {
            this.injector.getInstance(SpigotProtocolSupportHandler.class);
            SpigotProtocolSupportListener.registerHack((Plugin)this);
        }
    }

    public void onDisable() {
        this.platform.disable();
    }
}

