/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import org.geysermc.floodgate.addon.data.CommonDataHandler;
import org.geysermc.floodgate.addon.data.PacketBlocker;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ProxyUtils;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class SpigotDataHandler
extends CommonDataHandler {
    private Object networkManager;
    private FloodgatePlayer player;

    public SpigotDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute) {
        super(handshakeHandler, config, kickMessageAttribute, new PacketBlocker());
    }

    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ReflectionUtils.setValue((Object)this.networkManager, (Field)ClassNames.SOCKET_ADDRESS, (Object)newIp);
    }

    protected Object setHostname(Object handshakePacket, String hostname) {
        ReflectionUtils.setValue((Object)handshakePacket, (Field)ClassNames.HANDSHAKE_HOST, (Object)hostname);
        return handshakePacket;
    }

    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        this.player = result.getFloodgatePlayer();
        if (this.getKickMessage() != null) {
            return false;
        }
        if (this.player == null) {
            return true;
        }
        boolean bungeeData = ProxyUtils.isProxyData();
        if (!bungeeData) {
            ReflectionUtils.setValue((Object)this.networkManager, (String)"spoofedUUID", (Object)this.player.getCorrectUniqueId());
        }
        return bungeeData;
    }

    protected boolean shouldCallFireRead(Object queuedPacket) {
        try {
            if (this.checkAndHandleLogin(queuedPacket)) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public boolean channelRead(Object packet) throws Exception {
        if (ClassNames.HANDSHAKE_PACKET.isInstance(packet)) {
            this.ctx.pipeline().addAfter("splitter", "floodgate_packet_blocker", (ChannelHandler)this.blocker);
            this.networkManager = this.ctx.channel().pipeline().get("packet_handler");
            this.handle(packet, (String)ReflectionUtils.getCastedValue((Object)packet, (Field)ClassNames.HANDSHAKE_HOST));
            return false;
        }
        return !this.checkAndHandleLogin(packet);
    }

    private boolean checkAndHandleLogin(Object packet) throws Exception {
        if (ClassNames.LOGIN_START_PACKET.isInstance(packet)) {
            Object packetListener = ClassNames.PACKET_LISTENER.get(this.networkManager);
            String kickMessage = this.getKickMessage();
            if (kickMessage != null) {
                this.disconnect(packetListener, kickMessage);
                return true;
            }
            if (!ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
                this.ctx.pipeline().remove((ChannelHandler)this);
                return true;
            }
            GameProfile gameProfile = new GameProfile(this.player.getCorrectUniqueId(), this.player.getCorrectUsername());
            ReflectionUtils.setValue((Object)packetListener, (Field)ClassNames.LOGIN_PROFILE, (Object)gameProfile);
            ClassNames.INIT_UUID.invoke(packetListener, new Object[0]);
            Object loginHandler = ClassNames.LOGIN_HANDLER_CONSTRUCTOR.newInstance(packetListener);
            ClassNames.FIRE_LOGIN_EVENTS.invoke(loginHandler, new Object[0]);
            this.ctx.pipeline().remove((ChannelHandler)this);
            return true;
        }
        return false;
    }

    private void disconnect(Object packetListener, String kickMessage) throws Exception {
        if (ClassNames.LOGIN_LISTENER.isInstance(packetListener)) {
            ClassNames.LOGIN_DISCONNECT.invoke(packetListener, kickMessage);
        } else {
            ClassNames.NETWORK_EXCEPTION_CAUGHT.invoke(this.networkManager, this.ctx, new IllegalStateException(kickMessage));
        }
    }
}

