/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.spigot;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.spigot.CustomList;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class SpigotInjector
extends CommonPlatformInjector {
    private Object serverConnection;
    private String injectedFieldName;
    private boolean injected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inject() throws Exception {
        if (this.isInjected()) {
            return true;
        }
        if (this.getServerConnection() != null) {
            for (Field field : this.serverConnection.getClass().getDeclaredFields()) {
                CustomList newList;
                if (field.getType() != List.class) continue;
                field.setAccessible(true);
                ParameterizedType parameterType = (ParameterizedType)field.getGenericType();
                Type listType = parameterType.getActualTypeArguments()[0];
                if (listType != ChannelFuture.class) continue;
                this.injectedFieldName = field.getName();
                CustomList customList = newList = new CustomList((List)field.get(this.serverConnection)){

                    @Override
                    public void onAdd(Object object) {
                        try {
                            SpigotInjector.this.injectClient((ChannelFuture)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                synchronized (customList) {
                    for (Object object : newList) {
                        try {
                            this.injectClient((ChannelFuture)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                field.set(this.serverConnection, newList);
                this.injected = true;
                return true;
            }
        }
        return false;
    }

    public void injectClient(ChannelFuture future) {
        future.channel().pipeline().addFirst("floodgate-init", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                super.channelRead(ctx, msg);
                Channel channel = (Channel)msg;
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel channel) {
                        SpigotInjector.this.injectAddonsCall(channel, false);
                        SpigotInjector.this.addInjectedClient(channel);
                    }
                }});
            }
        });
    }

    public boolean removeInjection() throws Exception {
        Field field;
        List list;
        if (!this.isInjected()) {
            return true;
        }
        for (Channel channel : this.getInjectedClients()) {
            this.removeAddonsCall(channel);
        }
        this.getInjectedClients().clear();
        Object serverConnection = this.getServerConnection();
        if (serverConnection != null && (list = (List)ReflectionUtils.getValue((Object)serverConnection, (Field)(field = ReflectionUtils.getField(serverConnection.getClass(), (String)this.injectedFieldName)))) instanceof CustomList) {
            CustomList customList = (CustomList)list;
            ReflectionUtils.setValue((Object)serverConnection, (Field)field, (Object)customList.getOriginalList());
            customList.clear();
            customList.addAll((Collection)list);
        }
        this.injected = false;
        return true;
    }

    public Object getServerConnection() throws IllegalAccessException, InvocationTargetException {
        if (this.serverConnection != null) {
            return this.serverConnection;
        }
        Class<?> minecraftServer = ClassNames.MINECRAFT_SERVER;
        Object minecraftServerInstance = ReflectionUtils.invokeStatic(minecraftServer, (String)"getServer");
        for (Method method : minecraftServer.getDeclaredMethods()) {
            if (!ClassNames.SERVER_CONNECTION.equals(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
            this.serverConnection = method.invoke(minecraftServerInstance, new Object[0]);
        }
        return this.serverConnection;
    }

    public boolean isInjected() {
        return this.injected;
    }
}

