/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import com.google.inject.Inject;
import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.SpigotCommandUtil;

public final class SpigotListener
implements Listener {
    @Inject
    private SimpleFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerLogin(PlayerLoginEvent event) {
        UUID uniqueId = event.getPlayer().getUniqueId();
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        FloodgatePlayer player = this.api.getPlayer(uniqueId);
        if (player != null) {
            ((FloodgatePlayerImpl)player.as(FloodgatePlayerImpl.class)).setLogin(false);
            this.logger.translatedInfo("floodgate.ingame.login_name", new Object[]{player.getCorrectUsername(), player.getCorrectUniqueId()});
            this.languageManager.loadLocale(player.getLanguageCode());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        SpigotCommandUtil.AUDIENCE_CACHE.remove(event.getPlayer().getUniqueId());
    }
}

