/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.geysermc.floodgate.SpigotPlugin;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.spigot.SpigotInjector;
import org.geysermc.floodgate.listener.SpigotListenerRegistration;
import org.geysermc.floodgate.logger.JavaUtilFloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.listener.ListenerRegistration;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.SpigotPluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.SpigotPluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.SpigotSkinApplier;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.SpigotCommandUtil;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

public final class SpigotPlatformModule
extends AbstractModule {
    private final SpigotPlugin plugin;

    @Provides
    @Singleton
    public JavaPlugin javaPlugin() {
        return this.plugin;
    }

    @Provides
    @Singleton
    public FloodgateLogger floodgateLogger(LanguageManager languageManager) {
        return new JavaUtilFloodgateLogger(this.plugin.getLogger(), languageManager);
    }

    @Provides
    @Singleton
    public CommandUtil commandUtil(FloodgateApi api, SpigotVersionSpecificMethods versionSpecificMethods, FloodgateLogger logger, LanguageManager languageManager) {
        return new SpigotCommandUtil(this.plugin.getServer(), api, versionSpecificMethods, this.plugin, logger, languageManager);
    }

    @Provides
    @Singleton
    public ListenerRegistration<Listener> listenerRegistration() {
        return new SpigotListenerRegistration(this.plugin);
    }

    @Provides
    @Singleton
    public CommonPlatformInjector platformInjector() {
        return new SpigotInjector();
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "packet_handler";
    }

    @Provides
    @Named(value="implementationName")
    public String implementationName() {
        return "Spigot";
    }

    @Provides
    @Singleton
    public PluginMessageUtils pluginMessageUtils() {
        return new SpigotPluginMessageUtils(this.plugin);
    }

    @Provides
    @Singleton
    public PluginMessageRegistration pluginMessageRegister() {
        return new SpigotPluginMessageRegistration(this.plugin);
    }

    @Provides
    @Singleton
    public SkinApplier skinApplier(SpigotVersionSpecificMethods versionSpecificMethods) {
        return new SpigotSkinApplier(versionSpecificMethods, this.plugin);
    }

    @Provides
    @Singleton
    public SpigotVersionSpecificMethods versionSpecificMethods() {
        return new SpigotVersionSpecificMethods(this.plugin);
    }

    public SpigotPlatformModule(SpigotPlugin plugin) {
        this.plugin = plugin;
    }
}

