/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.floodgate.SpigotPlugin;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.skin.SkinData;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

public final class SpigotSkinApplier
implements SkinApplier {
    private final SpigotVersionSpecificMethods versionSpecificMethods;
    private final SpigotPlugin plugin;

    public SpigotSkinApplier(SpigotVersionSpecificMethods versionSpecificMethods, SpigotPlugin plugin) {
        this.versionSpecificMethods = versionSpecificMethods;
        this.plugin = plugin;
    }

    public void applySkin(FloodgatePlayer floodgatePlayer, SkinData skinData) {
        this.applySkin0(floodgatePlayer, skinData, true);
    }

    private void applySkin0(FloodgatePlayer floodgatePlayer, SkinData skinData, boolean firstTry) {
        Player player = Bukkit.getPlayer((UUID)floodgatePlayer.getCorrectUniqueId());
        if (player == null) {
            if (firstTry) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applySkin0(floodgatePlayer, skinData, false), 10000L);
            }
            return;
        }
        GameProfile profile = (GameProfile)ReflectionUtils.castedInvoke((Object)player, (Method)ClassNames.GET_PROFILE_METHOD, (Object[])new Object[0]);
        if (profile == null) {
            throw new IllegalStateException("The GameProfile cannot be null! " + player.getName());
        }
        PropertyMap properties = profile.getProperties();
        properties.removeAll((Object)"textures");
        Property property = new Property("textures", skinData.getValue(), skinData.getSignature());
        properties.put((Object)"textures", (Object)property);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.equals(player) || !p.canSee(player)) continue;
                this.versionSpecificMethods.hidePlayer(p, player);
                this.versionSpecificMethods.showPlayer(p, player);
            }
        });
    }
}

