/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import org.bukkit.Bukkit;
import org.geysermc.floodgate.util.ReflectionUtils;

public class ClassNames {
    public static final String SPIGOT_MAPPING_PREFIX;
    public static final Class<?> MINECRAFT_SERVER;
    public static final Class<?> SERVER_CONNECTION;
    public static final Class<?> HANDSHAKE_PACKET;
    public static final Class<?> LOGIN_START_PACKET;
    public static final Class<?> LOGIN_LISTENER;
    public static final Class<?> LOGIN_HANDLER;
    public static final Constructor<?> WHITELIST_ENTRY;
    public static final Constructor<?> LOGIN_HANDLER_CONSTRUCTOR;
    public static final Field SOCKET_ADDRESS;
    public static final Field HANDSHAKE_HOST;
    public static final Field LOGIN_PROFILE;
    public static final Field PACKET_LISTENER;
    public static final Method GET_PROFILE_METHOD;
    public static final Method GET_SERVER;
    public static final Method GET_PLAYER_LIST;
    public static final Method GET_WHITELIST;
    public static final Method IS_WHITELISTED;
    public static final Method ADD_WHITELIST_ENTRY;
    public static final Method REMOVE_WHITELIST_ENTRY;
    public static final Method LOGIN_DISCONNECT;
    public static final Method NETWORK_EXCEPTION_CAUGHT;
    public static final Method INIT_UUID;
    public static final Method FIRE_LOGIN_EVENTS;

    private static Class<?> getClassOrFallBack(String className, String fallbackName) {
        Class clazz = ReflectionUtils.getClassSilently((String)className);
        if (clazz != null) {
            return clazz;
        }
        clazz = ReflectionUtils.getClassOrThrow((String)fallbackName);
        return clazz;
    }

    private static void checkNotNull(Object toCheck, String objectName) {
        Preconditions.checkNotNull((Object)toCheck, (Object)(objectName + " cannot be null"));
    }

    static {
        Constructor loginHandlerConstructor;
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        SPIGOT_MAPPING_PREFIX = "net.minecraft.server." + version;
        Class craftPlayerClass = ReflectionUtils.getClass((String)("org.bukkit.craftbukkit." + version + ".entity.CraftPlayer"));
        GET_PROFILE_METHOD = ReflectionUtils.getMethod((Class)craftPlayerClass, (String)"getProfile", (Class[])new Class[0]);
        ClassNames.checkNotNull(GET_PROFILE_METHOD, "Get profile method");
        version = SPIGOT_MAPPING_PREFIX + '.';
        MINECRAFT_SERVER = ClassNames.getClassOrFallBack("net.minecraft.server.MinecraftServer", version + "MinecraftServer");
        SERVER_CONNECTION = ClassNames.getClassOrFallBack("net.minecraft.server.network.ServerConnection", version + "ServerConnection");
        GET_SERVER = ReflectionUtils.getMethod(MINECRAFT_SERVER, MINECRAFT_SERVER, (boolean)true, (Class[])new Class[0]);
        ClassNames.checkNotNull(GET_SERVER, "Get server cannot be null");
        Class<?> playerList = ClassNames.getClassOrFallBack("net.minecraft.server.players.PlayerList", version + "PlayerList");
        GET_PLAYER_LIST = ReflectionUtils.getMethod(MINECRAFT_SERVER, playerList, (boolean)true, (Class[])new Class[0]);
        ClassNames.checkNotNull(GET_PLAYER_LIST, "Get player list");
        Class<?> whitelist = ClassNames.getClassOrFallBack("net.minecraft.server.players.WhiteList", version + "WhiteList");
        GET_WHITELIST = ReflectionUtils.getMethod(playerList, whitelist, (boolean)true, (Class[])new Class[0]);
        ClassNames.checkNotNull(GET_WHITELIST, "Get whitelist");
        IS_WHITELISTED = ReflectionUtils.getMethodByName(whitelist, (String)"isWhitelisted", (boolean)true);
        ClassNames.checkNotNull(IS_WHITELISTED, "Is whitelisted");
        Class<?> whitelistEntry = ClassNames.getClassOrFallBack("net.minecraft.server.players.WhiteListEntry", version + "WhiteListEntry");
        WHITELIST_ENTRY = ReflectionUtils.getConstructor(whitelistEntry, (Class[])new Class[]{GameProfile.class});
        ClassNames.checkNotNull(WHITELIST_ENTRY, "Whitelist entry constructor");
        Class<?> jsonList = ClassNames.getClassOrFallBack("net.minecraft.server.players.JsonList", version + "JsonList");
        ADD_WHITELIST_ENTRY = ReflectionUtils.getMethodByName(jsonList, (String)"add", (boolean)true);
        ClassNames.checkNotNull(ADD_WHITELIST_ENTRY, "Add whitelist entry");
        REMOVE_WHITELIST_ENTRY = ReflectionUtils.getMethodByName(jsonList, (String)"remove", (boolean)true);
        ClassNames.checkNotNull(REMOVE_WHITELIST_ENTRY, "Remove whitelist entry");
        Class<?> networkManager = ClassNames.getClassOrFallBack("net.minecraft.network.NetworkManager", version + "NetworkManager");
        SOCKET_ADDRESS = ReflectionUtils.getFieldOfType(networkManager, SocketAddress.class, (boolean)false);
        HANDSHAKE_PACKET = ClassNames.getClassOrFallBack("net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol", version + "PacketHandshakingInSetProtocol");
        HANDSHAKE_HOST = ReflectionUtils.getFieldOfType(HANDSHAKE_PACKET, String.class);
        ClassNames.checkNotNull(HANDSHAKE_HOST, "Handshake host");
        LOGIN_START_PACKET = ClassNames.getClassOrFallBack("net.minecraft.network.protocol.login.PacketLoginInStart", version + "PacketLoginInStart");
        LOGIN_LISTENER = ClassNames.getClassOrFallBack("net.minecraft.server.network.LoginListener", version + "LoginListener");
        LOGIN_PROFILE = ReflectionUtils.getFieldOfType(LOGIN_LISTENER, GameProfile.class);
        ClassNames.checkNotNull(LOGIN_PROFILE, "Profile from LoginListener");
        LOGIN_DISCONNECT = ReflectionUtils.getMethod(LOGIN_LISTENER, (String)"disconnect", (Class[])new Class[]{String.class});
        ClassNames.checkNotNull(LOGIN_DISCONNECT, "LoginListener's disconnect method");
        NETWORK_EXCEPTION_CAUGHT = ReflectionUtils.getMethod(networkManager, (String)"exceptionCaught", (Class[])new Class[]{ChannelHandlerContext.class, Throwable.class});
        INIT_UUID = ReflectionUtils.getMethod(LOGIN_LISTENER, (String)"initUUID", (Class[])new Class[0]);
        ClassNames.checkNotNull(INIT_UUID, "initUUID from LoginListener");
        Class<?> packetListenerClass = ClassNames.getClassOrFallBack("net.minecraft.network.PacketListener", version + "PacketListener");
        PACKET_LISTENER = ReflectionUtils.getFieldOfType(networkManager, packetListenerClass);
        ClassNames.checkNotNull(PACKET_LISTENER, "Packet listener");
        LOGIN_HANDLER = ClassNames.getClassOrFallBack("net.minecraft.server.network.LoginListener$LoginHandler", version + "LoginListener$LoginHandler");
        try {
            loginHandlerConstructor = (Constructor)ReflectionUtils.makeAccessible(LOGIN_HANDLER.getDeclaredConstructor(LOGIN_LISTENER));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        LOGIN_HANDLER_CONSTRUCTOR = loginHandlerConstructor;
        ClassNames.checkNotNull(LOGIN_HANDLER_CONSTRUCTOR, "LoginHandler constructor");
        FIRE_LOGIN_EVENTS = ReflectionUtils.getMethod(LOGIN_HANDLER, (String)"fireEvents", (Class[])new Class[0]);
        ClassNames.checkNotNull(FIRE_LOGIN_EVENTS, "fireEvents from LoginHandler");
    }
}

