/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class ProxyUtils {
    private static final Field IS_BUNGEE_DATA;
    private static final Field IS_MODERN_FORWARDING;

    public static boolean isProxyData() {
        return ProxyUtils.isBungeeData() || ProxyUtils.isVelocitySupport();
    }

    private static boolean isBungeeData() {
        return (Boolean)ReflectionUtils.getCastedValue(null, (Field)IS_BUNGEE_DATA);
    }

    private static boolean isVelocitySupport() {
        if (IS_MODERN_FORWARDING == null) {
            return false;
        }
        return (Boolean)ReflectionUtils.getCastedValue(null, (Field)IS_MODERN_FORWARDING);
    }

    static {
        Field velocitySupport;
        Class spigotConfig = ReflectionUtils.getClass((String)"org.spigotmc.SpigotConfig");
        IS_BUNGEE_DATA = ReflectionUtils.getField((Class)spigotConfig, (String)"bungee");
        Preconditions.checkNotNull((Object)IS_BUNGEE_DATA, (Object)"bungee field cannot be null. Are you using CraftBukkit?");
        try {
            Class<?> paperConfig = Class.forName("com.destroystokyo.paper.PaperConfig");
            velocitySupport = ReflectionUtils.getField(paperConfig, (String)"velocitySupport");
        }
        catch (ClassNotFoundException e) {
            velocitySupport = null;
        }
        IS_MODERN_FORWARDING = velocitySupport;
    }
}

