/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.SpigotUserAudience;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;
import org.geysermc.floodgate.util.WhitelistUtils;

public final class SpigotCommandUtil
implements CommandUtil {
    public static final @NonNull Map<UUID, UserAudience> AUDIENCE_CACHE = new HashMap<UUID, UserAudience>();
    private static UserAudience console;
    private final Server server;
    private final FloodgateApi api;
    private final SpigotVersionSpecificMethods versionSpecificMethods;
    private final JavaPlugin plugin;
    private final FloodgateLogger logger;
    private final LanguageManager manager;

    public @NonNull UserAudience getAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSender)) {
            throw new IllegalArgumentException("Source has to be a CommandSender!");
        }
        CommandSender source = (CommandSender)sourceObj;
        if (!(source instanceof Player)) {
            if (console != null) {
                return console;
            }
            console = new SpigotUserAudience.SpigotConsoleAudience(source, this);
            return console;
        }
        Player player = (Player)source;
        UUID uuid = player.getUniqueId();
        String locale = this.versionSpecificMethods.getLocale(player);
        return AUDIENCE_CACHE.computeIfAbsent(uuid, $ -> new SpigotUserAudience.SpigotPlayerAudience(uuid, locale, source, true, this));
    }

    public @Nullable UserAudience getAudienceByUsername(@NonNull String username) {
        Player player = this.server.getPlayer(username);
        return player != null ? this.getAudience(player) : null;
    }

    public @NonNull UserAudience getOfflineAudienceByUsername(@NonNull String username) {
        return new SpigotUserAudience.SpigotPlayerAudience(null, username, null, null, false, this);
    }

    public @Nullable UserAudience getAudienceByUuid(@NonNull UUID uuid) {
        Player player = this.server.getPlayer(uuid);
        return player != null ? this.getAudience(player) : null;
    }

    public @NonNull UserAudience getOfflineAudienceByUuid(@NonNull UUID uuid) {
        return new SpigotUserAudience.SpigotPlayerAudience(uuid, null, null, null, false, this);
    }

    public @NonNull Collection<String> getOnlineUsernames(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UserAudienceArgument.PlayerType limitTo) {
        Collection players = this.server.getOnlinePlayers();
        ArrayList<String> usernames = new ArrayList<String>();
        switch (limitTo) {
            case ALL_PLAYERS: {
                for (Player player : players) {
                    usernames.add(player.getName());
                }
                break;
            }
            case ONLY_JAVA: {
                for (Player player : players) {
                    if (this.api.isFloodgatePlayer(player.getUniqueId())) continue;
                    usernames.add(player.getName());
                }
                break;
            }
            case ONLY_BEDROCK: {
                for (Player player : players) {
                    if (!this.api.isFloodgatePlayer(player.getUniqueId())) continue;
                    usernames.add(player.getName());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PlayerType");
            }
        }
        return usernames;
    }

    public boolean hasPermission(Object player, String permission) {
        return this.cast(player).hasPermission(permission);
    }

    public Collection<Object> getOnlinePlayersWithPermission(String permission) {
        ArrayList<Object> players = new ArrayList<Object>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.hasPermission(player, permission)) continue;
            players.add(player);
        }
        return players;
    }

    public void sendMessage(Object target, String locale, TranslatableMessage message, Object ... args) {
        this.sendMessage(target, this.translateAndTransform(locale, message, args));
    }

    public void sendMessage(Object target, String message) {
        ((CommandSender)target).sendMessage(message);
    }

    public void kickPlayer(Object player, String locale, TranslatableMessage message, Object ... args) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.cast(player).kickPlayer(this.translateAndTransform(locale, message, args)));
    }

    public boolean whitelistPlayer(UUID uuid, String username) {
        return WhitelistUtils.addPlayer(uuid, username);
    }

    public boolean removePlayerFromWhitelist(UUID uuid, String username) {
        return WhitelistUtils.removePlayer(uuid, username);
    }

    public String translateAndTransform(String locale, TranslatableMessage message, Object ... args) {
        return message.translateMessage(this.manager, locale, args);
    }

    private Player cast(Object instance) {
        try {
            return (Player)instance;
        }
        catch (ClassCastException exception) {
            this.logger.error("Failed to cast {} to Player", new Object[]{instance.getClass().getName()});
            throw exception;
        }
    }

    public SpigotCommandUtil(Server server, FloodgateApi api, SpigotVersionSpecificMethods versionSpecificMethods, JavaPlugin plugin, FloodgateLogger logger, LanguageManager manager) {
        this.server = server;
        this.api = api;
        this.versionSpecificMethods = versionSpecificMethods;
        this.plugin = plugin;
        this.logger = logger;
        this.manager = manager;
    }
}

