/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.lang.reflect.Method;
import java.util.UUID;
import org.geysermc.floodgate.api.packet.PacketHandler;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;

public class SpigotProtocolSupportHandler
implements PacketHandler {
    private static final Method getFromChannel;
    private static final Method getLoginProfile;
    private static final Method setName;
    private static final Method setOriginalName;
    private static final Method setUuid;
    private static final Method setOriginalUuid;
    private static final Method getNetworkManagerWrapper;
    private static final Method getPacketListener;
    private static final Method handleLoginStart;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;

    @Inject
    public void register(PacketHandlers packetHandlers) {
        packetHandlers.register((PacketHandler)this, ClassNames.LOGIN_START_PACKET);
    }

    public Object handle(ChannelHandlerContext ctx, Object packet, boolean serverbound) {
        FloodgatePlayer player = (FloodgatePlayer)ctx.channel().attr(this.playerAttribute).get();
        if (player == null) {
            return packet;
        }
        Object connection = ReflectionUtils.invoke(null, (Method)getFromChannel, (Object[])new Object[]{ctx.channel()});
        Object profile = ReflectionUtils.invoke((Object)connection, (Method)getLoginProfile, (Object[])new Object[0]);
        ReflectionUtils.invoke((Object)profile, (Method)setName, (Object[])new Object[]{player.getCorrectUsername()});
        ReflectionUtils.invoke((Object)profile, (Method)setOriginalName, (Object[])new Object[]{player.getCorrectUsername()});
        ReflectionUtils.invoke((Object)profile, (Method)setUuid, (Object[])new Object[]{player.getCorrectUniqueId()});
        ReflectionUtils.invoke((Object)profile, (Method)setOriginalUuid, (Object[])new Object[]{player.getCorrectUniqueId()});
        Object temp = ReflectionUtils.invoke((Object)connection, (Method)getNetworkManagerWrapper, (Object[])new Object[0]);
        temp = ReflectionUtils.invoke((Object)temp, (Method)getPacketListener, (Object[])new Object[0]);
        ReflectionUtils.invoke((Object)temp, (Method)handleLoginStart, (Object[])new Object[]{player.getCorrectUsername()});
        return packet;
    }

    static {
        Class connectionImpl = ReflectionUtils.getClass((String)"protocolsupport.protocol.ConnectionImpl");
        getFromChannel = ReflectionUtils.getMethod((Class)connectionImpl, (String)"getFromChannel", (Class[])new Class[]{Channel.class});
        getLoginProfile = ReflectionUtils.getMethod((Class)connectionImpl, (String)"getLoginProfile", (Class[])new Class[0]);
        Class profile = ReflectionUtils.getClass((String)"protocolsupport.protocol.utils.authlib.LoginProfile");
        setName = ReflectionUtils.getMethod((Class)profile, (String)"setName", (Class[])new Class[]{String.class});
        setOriginalName = ReflectionUtils.getMethod((Class)profile, (String)"setOriginalName", (Class[])new Class[]{String.class});
        setUuid = ReflectionUtils.getMethod((Class)profile, (String)"setUUID", (Class[])new Class[]{UUID.class});
        setOriginalUuid = ReflectionUtils.getMethod((Class)profile, (String)"setOriginalUUID", (Class[])new Class[]{UUID.class});
        getNetworkManagerWrapper = ReflectionUtils.getMethod((Class)connectionImpl, (String)"getNetworkManagerWrapper", (Class[])new Class[0]);
        Class networkManagerWrapper = ReflectionUtils.getClass((String)"protocolsupport.zplatform.network.NetworkManagerWrapper");
        getPacketListener = ReflectionUtils.getMethod((Class)networkManagerWrapper, (String)"getPacketListener", (Class[])new Class[0]);
        Class loginListener = ReflectionUtils.getClass((String)"protocolsupport.protocol.packet.handler.AbstractLoginListener");
        handleLoginStart = ReflectionUtils.getMethod((Class)loginListener, (String)"handleLoginStart", (Class[])new Class[]{String.class});
    }
}

