/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import java.nio.file.Path;
import org.geysermc.floodgate.FloodgatePlatform;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.module.CommandModule;
import org.geysermc.floodgate.module.PluginMessageModule;
import org.geysermc.floodgate.module.ProxyCommonModule;
import org.geysermc.floodgate.module.VelocityAddonModule;
import org.geysermc.floodgate.module.VelocityListenerModule;
import org.geysermc.floodgate.module.VelocityPlatformModule;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityPlugin {
    private final FloodgatePlatform platform;

    @Inject
    public VelocityPlugin(@DataDirectory Path dataDirectory, Injector guice) {
        ReflectionUtils.setPrefix((String)"com.velocitypowered.proxy");
        long ctm = System.currentTimeMillis();
        Injector injector = guice.createChildInjector(new Module[]{new ProxyCommonModule(dataDirectory), new VelocityPlatformModule(guice)});
        this.platform = (FloodgatePlatform)injector.getInstance(FloodgatePlatform.class);
        long endCtm = System.currentTimeMillis();
        ((FloodgateLogger)injector.getInstance(FloodgateLogger.class)).translatedInfo("floodgate.core.finish", new Object[]{endCtm - ctm});
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.platform.enable(new Module[]{new CommandModule(), new VelocityListenerModule(), new VelocityAddonModule(), new PluginMessageModule()});
    }
}

