/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.AttributeKey;
import org.geysermc.floodgate.addon.data.VelocityProxyDataHandler;
import org.geysermc.floodgate.addon.data.VelocityServerDataHandler;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.inject.InjectorAddon;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.Utils;

public final class VelocityDataAddon
implements InjectorAddon {
    @Inject
    private FloodgateHandshakeHandler handshakeHandler;
    @Inject
    private ProxyFloodgateConfig config;
    @Inject
    private ProxyFloodgateApi api;
    @Inject
    private ProxyServer proxy;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="packetHandler")
    private String packetHandler;
    @Inject
    @Named(value="packetEncoder")
    private String packetEncoder;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;

    public void onInject(Channel channel, boolean toServer) {
        if (toServer) {
            channel.pipeline().addAfter(this.packetEncoder, "floodgate_data_handler", (ChannelHandler)new VelocityServerDataHandler(this.config, this.api, this.proxy));
            return;
        }
        channel.pipeline().addBefore(this.packetHandler, "floodgate_data_handler", (ChannelHandler)new VelocityProxyDataHandler(this.config, this.handshakeHandler, this.kickMessageAttribute, this.logger));
    }

    public void onLoginDone(Channel channel) {
        this.onRemoveInject(channel);
    }

    public void onChannelClosed(Channel channel) {
        FloodgatePlayer player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
        if (player != null && this.api.removePlayer(player)) {
            this.logger.translatedInfo("floodgate.ingame.disconnect_name", new Object[]{player.getUsername()});
        }
    }

    public void onRemoveInject(Channel channel) {
        Utils.removeHandler((ChannelPipeline)channel.pipeline(), (String)"floodgate_data_handler");
    }

    public boolean shouldInject() {
        return true;
    }
}

