/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityProxyDataHandler
extends ChannelInboundHandlerAdapter {
    private static final Field HANDSHAKE;
    private static final Class<?> HANDSHAKE_PACKET;
    private static final Field HANDSHAKE_SERVER_ADDRESS;
    private static final Field REMOTE_ADDRESS;
    private final ProxyFloodgateConfig config;
    private final FloodgateHandshakeHandler handshakeHandler;
    private final AttributeKey<String> kickMessageAttribute;
    private final FloodgateLogger logger;
    private boolean done;

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ReferenceCountUtil.retain((Object)msg);
        if (this.done || !HANDSHAKE_PACKET.isInstance(msg)) {
            ctx.fireChannelRead(msg);
            return;
        }
        this.handleClientToProxy(ctx, msg);
        ctx.fireChannelRead(msg);
        this.done = true;
    }

    private void handleClientToProxy(ChannelHandlerContext ctx, Object packet) {
        String address = (String)ReflectionUtils.getCastedValue((Object)packet, (Field)HANDSHAKE_SERVER_ADDRESS);
        FloodgateHandshakeHandler.HandshakeResult result = this.handshakeHandler.handle(ctx.channel(), address);
        HandshakeData handshakeData = result.getHandshakeData();
        InetSocketAddress newIp = result.getNewIp(ctx.channel());
        if (newIp != null) {
            ChannelHandler connection = ctx.pipeline().get("handler");
            ReflectionUtils.setValue((Object)connection, (Field)REMOTE_ADDRESS, (Object)newIp);
        }
        if (handshakeData.getDisconnectReason() != null) {
            ctx.channel().attr(this.kickMessageAttribute).set((Object)handshakeData.getDisconnectReason());
            return;
        }
        switch (result.getResultType()) {
            case SUCCESS: {
                break;
            }
            case EXCEPTION: {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)this.config.getDisconnect().getInvalidKey());
                return;
            }
            case INVALID_DATA_LENGTH: {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)this.config.getDisconnect().getInvalidArgumentsLength());
                return;
            }
            case TIMESTAMP_DENIED: {
                ctx.channel().attr(this.kickMessageAttribute).set((Object)"Something isn't right with this data. Try logging in again or contact a server administrator if the issue persists.");
                return;
            }
            default: {
                return;
            }
        }
        FloodgatePlayer player = result.getFloodgatePlayer();
        ReflectionUtils.setValue((Object)packet, (Field)HANDSHAKE_SERVER_ADDRESS, (Object)handshakeData.getHostname());
        this.logger.info("Floodgate player who is logged in as {} {} joined", new Object[]{player.getCorrectUsername(), player.getCorrectUniqueId()});
    }

    public VelocityProxyDataHandler(ProxyFloodgateConfig config, FloodgateHandshakeHandler handshakeHandler, AttributeKey<String> kickMessageAttribute, FloodgateLogger logger) {
        this.config = config;
        this.handshakeHandler = handshakeHandler;
        this.kickMessageAttribute = kickMessageAttribute;
        this.logger = logger;
    }

    static {
        Class iic = ReflectionUtils.getPrefixedClass((String)"connection.client.InitialInboundConnection");
        Preconditions.checkNotNull((Object)iic, (Object)"InitialInboundConnection class cannot be null");
        HANDSHAKE = ReflectionUtils.getField((Class)iic, (String)"handshake");
        Preconditions.checkNotNull((Object)HANDSHAKE, (Object)"Handshake field cannot be null");
        HANDSHAKE_PACKET = ReflectionUtils.getPrefixedClass((String)"protocol.packet.Handshake");
        Preconditions.checkNotNull(HANDSHAKE_PACKET, (Object)"Handshake packet class cannot be null");
        HANDSHAKE_SERVER_ADDRESS = ReflectionUtils.getField(HANDSHAKE_PACKET, (String)"serverAddress");
        Preconditions.checkNotNull((Object)HANDSHAKE_SERVER_ADDRESS, (Object)"Address in the Handshake packet cannot be null");
        Class minecraftConnection = ReflectionUtils.getPrefixedClass((String)"connection.MinecraftConnection");
        REMOTE_ADDRESS = ReflectionUtils.getField((Class)minecraftConnection, (String)"remoteAddress");
    }
}

