/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.player.FloodgatePlayerImpl;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityServerDataHandler
extends MessageToMessageEncoder<Object> {
    private static final Class<?> HANDSHAKE_PACKET = ReflectionUtils.getPrefixedClass((String)"protocol.packet.Handshake");
    private static final Field HANDSHAKE_ADDRESS;
    private static final Method GET_ASSOCIATION;
    private static final Method GET_FORWARDING_MODE;
    private static final Method GET_PLAYER;
    private final ProxyFloodgateConfig config;
    private final ProxyFloodgateApi api;
    private final boolean isModernForwarding;
    private boolean done;

    public VelocityServerDataHandler(ProxyFloodgateConfig config, ProxyFloodgateApi api, ProxyServer proxy) {
        this.config = config;
        this.api = api;
        Enum forwardingMode = (Enum)ReflectionUtils.castedInvoke((Object)proxy.getConfiguration(), (Method)GET_FORWARDING_MODE, (Object[])new Object[0]);
        this.isModernForwarding = "MODERN".equals(forwardingMode.name());
    }

    protected void encode(ChannelHandlerContext ctx, Object packet, List<Object> out) {
        String remaining;
        String originalAddress;
        ReferenceCountUtil.retain((Object)packet);
        if (this.done) {
            out.add(packet);
            return;
        }
        if (!HANDSHAKE_PACKET.isInstance(packet) || !this.config.isSendFloodgateData()) {
            this.done = true;
            out.add(packet);
            return;
        }
        String address = (String)ReflectionUtils.getCastedValue((Object)packet, (Field)HANDSHAKE_ADDRESS);
        ChannelHandler minecraftConnection = ctx.pipeline().get("handler");
        Object association = ReflectionUtils.invoke((Object)minecraftConnection, (Method)GET_ASSOCIATION, (Object[])new Object[0]);
        Player velocityPlayer = (Player)ReflectionUtils.castedInvoke((Object)association, (Method)GET_PLAYER, (Object[])new Object[0]);
        FloodgatePlayer player = this.api.getPlayer(velocityPlayer.getUniqueId());
        if (player == null) {
            out.add(packet);
            return;
        }
        BedrockData data = ((FloodgatePlayerImpl)player.as(FloodgatePlayerImpl.class)).toBedrockData();
        String encryptedData = this.api.createEncryptedDataString(data);
        int addressFinished = address.indexOf(0);
        if (this.isModernForwarding && addressFinished == -1) {
            originalAddress = address;
            remaining = "";
        } else {
            originalAddress = address.substring(0, addressFinished);
            remaining = address.substring(addressFinished);
        }
        ReflectionUtils.setValue((Object)packet, (Field)HANDSHAKE_ADDRESS, (Object)(originalAddress + '\u0000' + encryptedData + remaining));
        this.done = true;
        out.add(packet);
    }

    static {
        Preconditions.checkNotNull(HANDSHAKE_PACKET, (Object)"Handshake packet class cannot be null");
        HANDSHAKE_ADDRESS = ReflectionUtils.getField(HANDSHAKE_PACKET, (String)"serverAddress");
        Preconditions.checkNotNull((Object)HANDSHAKE_ADDRESS, (Object)"Address field of the Handshake packet cannot be null");
        Class minecraftConnection = ReflectionUtils.getPrefixedClass((String)"connection.MinecraftConnection");
        GET_ASSOCIATION = ReflectionUtils.getMethod((Class)minecraftConnection, (String)"getAssociation", (Class[])new Class[0]);
        Preconditions.checkNotNull((Object)GET_ASSOCIATION, (Object)"getAssociation in MinecraftConnection cannot be null");
        Class configClass = ReflectionUtils.getPrefixedClass((String)"config.VelocityConfiguration");
        GET_FORWARDING_MODE = ReflectionUtils.getMethod((Class)configClass, (String)"getPlayerInfoForwardingMode", (Class[])new Class[0]);
        Preconditions.checkNotNull((Object)GET_FORWARDING_MODE, (Object)"getPlayerInfoForwardingMode in VelocityConfiguration cannot be null");
        Class serverConnection = ReflectionUtils.getPrefixedClass((String)"connection.backend.VelocityServerConnection");
        GET_PLAYER = ReflectionUtils.getMethod((Class)serverConnection, (String)"getPlayer", (Class[])new Class[0]);
        Preconditions.checkNotNull((Object)GET_PLAYER, (Object)"getPlayer in VelocityServerConnection cannot be null");
    }
}

