/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.velocity;

import com.velocitypowered.api.proxy.ProxyServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Method;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.util.ReflectionUtils;

public final class VelocityInjector
extends CommonPlatformInjector {
    private final ProxyServer server;
    private final FloodgateLogger logger;
    private boolean injected;

    public boolean inject() {
        if (this.isInjected()) {
            return true;
        }
        Object connectionManager = ReflectionUtils.getValue((Object)this.server, (String)"cm");
        Object serverInitializerHolder = ReflectionUtils.getValue((Object)connectionManager, (String)"serverChannelInitializer");
        ChannelInitializer serverInitializer = (ChannelInitializer)ReflectionUtils.castedInvoke((Object)serverInitializerHolder, (String)"get");
        Method serverSetter = ReflectionUtils.getMethod((Object)serverInitializerHolder, (String)"set", (Class[])new Class[]{ChannelInitializer.class});
        ReflectionUtils.invoke((Object)serverInitializerHolder, (Method)serverSetter, (Object[])new Object[]{new VelocityChannelInitializer(this, serverInitializer, false)});
        Object backendInitializerHolder = ReflectionUtils.getValue((Object)connectionManager, (String)"backendChannelInitializer");
        ChannelInitializer backendInitializer = (ChannelInitializer)ReflectionUtils.castedInvoke((Object)backendInitializerHolder, (String)"get");
        Method backendSetter = ReflectionUtils.getMethod((Object)backendInitializerHolder, (String)"set", (Class[])new Class[]{ChannelInitializer.class});
        ReflectionUtils.invoke((Object)backendInitializerHolder, (Method)backendSetter, (Object[])new Object[]{new VelocityChannelInitializer(this, backendInitializer, true)});
        this.injected = true;
        return true;
    }

    public boolean canRemoveInjection() {
        return false;
    }

    public boolean removeInjection() {
        this.logger.error("Floodgate cannot remove itself from Bungee without a reboot", new Object[0]);
        return false;
    }

    public VelocityInjector(ProxyServer server, FloodgateLogger logger) {
        this.server = server;
        this.logger = logger;
    }

    public boolean isInjected() {
        return this.injected;
    }

    private static final class VelocityChannelInitializer
    extends ChannelInitializer<Channel> {
        private static final Method initChannel = ReflectionUtils.getMethod(ChannelInitializer.class, (String)"initChannel", (Class[])new Class[]{Channel.class});
        private final VelocityInjector injector;
        private final ChannelInitializer original;
        private final boolean proxyToServer;

        protected void initChannel(Channel channel) {
            ReflectionUtils.invoke((Object)this.original, (Method)initChannel, (Object[])new Object[]{channel});
            this.injector.injectAddonsCall(channel, this.proxyToServer);
            this.injector.addInjectedClient(channel);
            channel.closeFuture().addListener(listener -> {
                this.injector.channelClosedCall(channel);
                this.injector.removeInjectedClient(channel);
            });
        }

        public VelocityChannelInitializer(VelocityInjector injector, ChannelInitializer original, boolean proxyToServer) {
            this.injector = injector;
            this.original = original;
            this.proxyToServer = proxyToServer;
        }
    }
}

