/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.util.GameProfile;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import org.geysermc.floodgate.api.ProxyFloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.ReflectionUtils;
import org.geysermc.floodgate.util.VelocityCommandUtil;

public final class VelocityListener {
    private static final Field INITIAL_MINECRAFT_CONNECTION;
    private static final Field CHANNEL;
    private final Cache<InboundConnection, FloodgatePlayer> playerCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(20L, TimeUnit.SECONDS).build();
    @Inject
    private ProxyFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;

    @Subscribe(order=PostOrder.EARLY)
    public void onPreLogin(PreLoginEvent event) {
        String kickMessage;
        FloodgatePlayer player = null;
        try {
            Object mcConnection = ReflectionUtils.getValue((Object)event.getConnection(), (Field)INITIAL_MINECRAFT_CONNECTION);
            Channel channel = (Channel)ReflectionUtils.getCastedValue((Object)mcConnection, (Field)CHANNEL);
            player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
            kickMessage = (String)channel.attr(this.kickMessageAttribute).get();
        }
        catch (Exception exception) {
            this.logger.error("Failed get the FloodgatePlayer from the player's channel", (Throwable)exception, new Object[0]);
            kickMessage = "Failed to get the FloodgatePlayer from the players's Channel";
        }
        if (kickMessage != null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)kickMessage)));
            return;
        }
        if (player != null) {
            event.setResult(PreLoginEvent.PreLoginComponentResult.forceOfflineMode());
            this.playerCache.put((Object)event.getConnection(), (Object)player);
        }
    }

    @Subscribe(order=PostOrder.EARLY)
    public void onGameProfileRequest(GameProfileRequestEvent event) {
        FloodgatePlayer player = (FloodgatePlayer)this.playerCache.getIfPresent((Object)event.getConnection());
        if (player != null) {
            this.playerCache.invalidate((Object)event.getConnection());
            event.setGameProfile(new GameProfile(player.getCorrectUniqueId(), player.getCorrectUsername(), new ArrayList()));
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onLogin(LoginEvent event) {
        FloodgatePlayer player;
        if (event.getResult().isAllowed() && (player = this.api.getPlayer(event.getPlayer().getUniqueId())) != null) {
            this.languageManager.loadLocale(player.getLanguageCode());
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onDisconnect(DisconnectEvent event) {
        VelocityCommandUtil.AUDIENCE_CACHE.remove(event.getPlayer().getUniqueId());
    }

    static {
        Class initialConnection = ReflectionUtils.getPrefixedClass((String)"connection.client.InitialInboundConnection");
        Class minecraftConnection = ReflectionUtils.getPrefixedClass((String)"connection.MinecraftConnection");
        INITIAL_MINECRAFT_CONNECTION = ReflectionUtils.getFieldOfType((Class)initialConnection, (Class)minecraftConnection);
        CHANNEL = ReflectionUtils.getFieldOfType((Class)minecraftConnection, Channel.class);
    }
}

