/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.logger;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.MessageFormatter;
import org.slf4j.Logger;

public final class Slf4jFloodgateLogger
implements FloodgateLogger {
    private final Logger logger;
    private final LanguageManager languageManager;

    public void error(String message, Object ... args) {
        this.logger.error(message, args);
    }

    public void error(String message, Throwable throwable, Object ... args) {
        this.logger.error(MessageFormatter.format((String)message, (Object[])args), throwable);
    }

    public void warn(String message, Object ... args) {
        this.logger.warn(message, args);
    }

    public void info(String message, Object ... args) {
        this.logger.info(message, args);
    }

    public void translatedInfo(String message, Object ... args) {
        this.logger.info(this.languageManager.getLogString(message, args));
    }

    public void debug(String message, Object ... args) {
        this.logger.debug(message, args);
    }

    public void trace(String message, Object ... args) {
        this.logger.trace(message, args);
    }

    public void enableDebug() {
        if (!this.logger.isDebugEnabled()) {
            Configurator.setLevel((String)this.logger.getName(), (Level)Level.DEBUG);
        }
    }

    public void disableDebug() {
        if (this.logger.isDebugEnabled()) {
            Configurator.setLevel((String)this.logger.getName(), (Level)Level.INFO);
        }
    }

    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    public Slf4jFloodgateLogger(Logger logger, LanguageManager languageManager) {
        this.logger = logger;
        this.languageManager = languageManager;
    }
}

