/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.player;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;

public abstract class VelocityUserAudience
implements UserAudience,
ForwardingAudience.Single {
    private final UUID uuid;
    private final String username;
    private final String locale;
    private final CommandSource source;
    private final CommandUtil commandUtil;

    public @NonNull UUID uuid() {
        return this.uuid;
    }

    public @NonNull String username() {
        return this.username;
    }

    public @NonNull String locale() {
        return this.locale;
    }

    public @NonNull CommandSource source() {
        return this.source;
    }

    public boolean hasPermission(@NonNull String permission) {
        return this.source.hasPermission(permission);
    }

    public void sendMessage(@NonNull Identity source, @NonNull Component message, @NonNull MessageType type) {
        this.source.sendMessage(source, message, type);
    }

    public void sendMessage(TranslatableMessage message, Object ... args) {
        this.commandUtil.sendMessage((Object)this.source(), this.locale(), message, args);
    }

    public void disconnect(@NonNull Component reason) {
        if (this.source instanceof Player) {
            ((Player)this.source).disconnect(reason);
        }
    }

    public void disconnect(TranslatableMessage message, Object ... args) {
        this.commandUtil.kickPlayer((Object)this.source(), this.locale(), message, args);
    }

    public @NonNull Audience audience() {
        return this.source;
    }

    public VelocityUserAudience(UUID uuid, String username, String locale, CommandSource source, CommandUtil commandUtil) {
        this.uuid = uuid;
        this.username = username;
        this.locale = locale;
        this.source = source;
        this.commandUtil = commandUtil;
    }

    public static final class VelocityPlayerAudience
    extends VelocityUserAudience
    implements UserAudience.PlayerAudience {
        private final boolean online;

        public VelocityPlayerAudience(UUID uuid, String username, String locale, CommandSource source, boolean online, CommandUtil commandUtil) {
            super(uuid, username, locale, source, commandUtil);
            this.online = online;
        }

        public boolean online() {
            return this.online;
        }
    }

    public static final class VelocityConsoleAudience
    extends VelocityUserAudience
    implements UserAudience.ConsoleAudience {
        public VelocityConsoleAudience(CommandSource source, CommandUtil commandUtil) {
            super(new UUID(0L, 0L), "CONSOLE", "en_us", source, commandUtil);
        }
    }
}

