/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.command.TranslatableMessage;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.player.VelocityUserAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.Utils;

public final class VelocityCommandUtil
implements CommandUtil {
    public static final @NonNull Map<UUID, UserAudience> AUDIENCE_CACHE = new HashMap<UUID, UserAudience>();
    private static UserAudience console;
    @Inject
    private ProxyServer server;
    @Inject
    private FloodgateApi api;
    @Inject
    private FloodgateLogger logger;
    @Inject
    private LanguageManager manager;

    public @NonNull UserAudience getAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSource)) {
            throw new IllegalArgumentException("Can only work with CommandSource!");
        }
        CommandSource source = (CommandSource)sourceObj;
        if (!(source instanceof Player)) {
            if (console != null) {
                return console;
            }
            console = new VelocityUserAudience.VelocityConsoleAudience(source, this);
            return console;
        }
        Player player = (Player)source;
        UUID uuid = player.getUniqueId();
        String username = player.getUsername();
        String locale = Utils.getLocale((Locale)player.getPlayerSettings().getLocale());
        return AUDIENCE_CACHE.computeIfAbsent(uuid, $ -> new VelocityUserAudience.VelocityPlayerAudience(uuid, username, locale, source, true, this));
    }

    public @Nullable UserAudience getAudienceByUsername(@NonNull String username) {
        return this.server.getPlayer(username).map(this::getAudience).orElse(null);
    }

    public @NonNull UserAudience getOfflineAudienceByUsername(@NonNull String username) {
        return new VelocityUserAudience.VelocityPlayerAudience(null, username, null, null, false, this);
    }

    public @Nullable UserAudience getAudienceByUuid(@NonNull UUID uuid) {
        return this.server.getPlayer(uuid).map(this::getAudience).orElse(null);
    }

    public @NonNull UserAudience getOfflineAudienceByUuid(@NonNull UUID uuid) {
        return new VelocityUserAudience.VelocityPlayerAudience(uuid, null, null, null, false, this);
    }

    public @NonNull Collection<String> getOnlineUsernames(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UserAudienceArgument.PlayerType limitTo) {
        Collection players = this.server.getAllPlayers();
        ArrayList<String> usernames = new ArrayList<String>();
        switch (limitTo) {
            case ALL_PLAYERS: {
                for (Player player : players) {
                    usernames.add(player.getUsername());
                }
                break;
            }
            case ONLY_JAVA: {
                for (Player player : players) {
                    if (this.api.isFloodgatePlayer(player.getUniqueId())) continue;
                    usernames.add(player.getUsername());
                }
                break;
            }
            case ONLY_BEDROCK: {
                for (Player player : players) {
                    if (!this.api.isFloodgatePlayer(player.getUniqueId())) continue;
                    usernames.add(player.getUsername());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PlayerType");
            }
        }
        return usernames;
    }

    public boolean hasPermission(Object player, String permission) {
        return this.cast(player).hasPermission(permission);
    }

    public Collection<Object> getOnlinePlayersWithPermission(String permission) {
        ArrayList<Object> players = new ArrayList<Object>();
        for (Player player : this.server.getAllPlayers()) {
            if (!this.hasPermission(player, permission)) continue;
            players.add(player);
        }
        return players;
    }

    public void sendMessage(Object target, String locale, TranslatableMessage message, Object ... args) {
        ((CommandSource)target).sendMessage(this.translateAndTransform(locale, message, args));
    }

    public void sendMessage(Object target, String message) {
        ((CommandSource)target).sendMessage((Component)Component.text((String)message));
    }

    public void kickPlayer(Object player, String locale, TranslatableMessage message, Object ... args) {
        this.cast(player).disconnect(this.translateAndTransform(locale, message, args));
    }

    public Component translateAndTransform(String locale, TranslatableMessage message, Object ... args) {
        return Component.text((String)message.translateMessage(this.manager, locale, args));
    }

    protected Player cast(Object instance) {
        try {
            return (Player)instance;
        }
        catch (ClassCastException exception) {
            this.logger.error("Failed to cast {} to Player", new Object[]{instance.getClass().getName()});
            throw exception;
        }
    }
}

